/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.microprofile.metrics.deployment;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.spi.AfterDeploymentValidation;
import javax.enterprise.inject.spi.AnnotatedMember;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedParameter;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.BeforeBeanDiscovery;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.enterprise.inject.spi.ProcessProducerField;
import javax.enterprise.inject.spi.ProcessProducerMethod;
import javax.enterprise.inject.spi.WithAnnotations;
import javax.enterprise.util.AnnotationLiteral;
import javax.enterprise.util.Nonbinding;
import javax.inject.Inject;
import javax.interceptor.InterceptorBinding;
import org.eclipse.microprofile.metrics.Metric;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.annotation.Counted;
import org.eclipse.microprofile.metrics.annotation.Gauge;
import org.eclipse.microprofile.metrics.annotation.Metered;
import org.eclipse.microprofile.metrics.annotation.Timed;
import org.jboss.logging.Logger;
import org.wildfly.swarm.microprofile.metrics.deployment.AMetricRegistryFactory;
import org.wildfly.swarm.microprofile.metrics.deployment.AnnotatedMethodDecorator;
import org.wildfly.swarm.microprofile.metrics.deployment.AnnotatedTypeDecorator;
import org.wildfly.swarm.microprofile.metrics.deployment.CountedInterceptor;
import org.wildfly.swarm.microprofile.metrics.deployment.MeteredInterceptor;
import org.wildfly.swarm.microprofile.metrics.deployment.MetricName;
import org.wildfly.swarm.microprofile.metrics.deployment.MetricNameFactory;
import org.wildfly.swarm.microprofile.metrics.deployment.MetricsBinding;
import org.wildfly.swarm.microprofile.metrics.deployment.MetricsInterceptor;
import org.wildfly.swarm.microprofile.metrics.deployment.TimedInterceptor;

public class MetricCdiInjectionExtension
implements Extension {
    private static final Logger LOGGER = Logger.getLogger((String)"org.wildfly.swarm.microprofile.metrics");
    private static final AnnotationLiteral<InterceptorBinding> INTERCEPTOR_BINDING = new AnnotationLiteral<InterceptorBinding>(){};
    private static final AnnotationLiteral<Nonbinding> NON_BINDING = new AnnotationLiteral<Nonbinding>(){};
    private static final AnnotationLiteral<MetricsBinding> METRICS_BINDING = new AnnotationLiteral<MetricsBinding>(){};
    private static final AnnotationLiteral<Default> DEFAULT = new AnnotationLiteral<Default>(){};
    private final Map<Bean<?>, AnnotatedMember<?>> metrics = new HashMap();
    @Inject
    MetricRegistry registry;

    public MetricCdiInjectionExtension() {
        LOGGER.infof("MetricCdiInjectionExtension", new Object[0]);
    }

    private void addInterceptorBindings(@Observes BeforeBeanDiscovery bbd, BeanManager manager) {
        LOGGER.info((Object)"MicroProfile: Metrics activated");
        MetricCdiInjectionExtension.declareAsInterceptorBinding(Counted.class, manager, bbd);
        MetricCdiInjectionExtension.declareAsInterceptorBinding(Gauge.class, manager, bbd);
        MetricCdiInjectionExtension.declareAsInterceptorBinding(Timed.class, manager, bbd);
        MetricCdiInjectionExtension.declareAsInterceptorBinding(Metered.class, manager, bbd);
        bbd.addAnnotatedType(manager.createAnnotatedType(AMetricRegistryFactory.class));
        bbd.addAnnotatedType(manager.createAnnotatedType(MetricNameFactory.class));
        bbd.addAnnotatedType(manager.createAnnotatedType(MeteredInterceptor.class));
        bbd.addAnnotatedType(manager.createAnnotatedType(CountedInterceptor.class));
        bbd.addAnnotatedType(manager.createAnnotatedType(TimedInterceptor.class));
        bbd.addAnnotatedType(manager.createAnnotatedType(MetricsInterceptor.class));
    }

    private <X> void metricsAnnotations(@Observes @WithAnnotations(value={Counted.class, Gauge.class, Metered.class, Timed.class}) ProcessAnnotatedType<X> pat) {
        AnnotatedTypeDecorator newPAT = new AnnotatedTypeDecorator(pat.getAnnotatedType(), (Annotation)METRICS_BINDING);
        LOGGER.debugf("annotations: %s", newPAT.getAnnotations());
        LOGGER.debugf("methods: %s", newPAT.getMethods());
        pat.setAnnotatedType(newPAT);
    }

    private void metricProducerField(@Observes ProcessProducerField<? extends Metric, ?> ppf) {
        LOGGER.infof("Metrics producer field discovered: %s", (Object)ppf.getAnnotatedProducerField());
        this.metrics.put((Bean<?>)ppf.getBean(), (AnnotatedMember<?>)ppf.getAnnotatedProducerField());
    }

    private void metricProducerMethod(@Observes ProcessProducerMethod<? extends Metric, ?> ppm) {
        if (!ppm.getBean().getBeanClass().equals(AMetricRegistryFactory.class)) {
            LOGGER.infof("Metrics producer method discovered: %s", (Object)ppm.getAnnotatedProducerMethod());
            this.metrics.put((Bean<?>)ppm.getBean(), (AnnotatedMember<?>)ppm.getAnnotatedProducerMethod());
        }
    }

    void registerMetrics(@Observes AfterDeploymentValidation adv, BeanManager manager) {
        MetricRegistry registry = MetricCdiInjectionExtension.getReference(manager, MetricRegistry.class);
        MetricName name = MetricCdiInjectionExtension.getReference(manager, MetricName.class);
        for (Map.Entry<Bean<?>, AnnotatedMember<?>> bean : this.metrics.entrySet()) {
            if (!bean.getKey().getQualifiers().contains(DEFAULT) || MetricCdiInjectionExtension.hasInjectionPointMetadata(bean.getValue())) continue;
            String metricName = name.of(bean.getValue());
            registry.register(metricName, (Metric)MetricCdiInjectionExtension.getReference(manager, bean.getValue().getBaseType(), bean.getKey()));
        }
        this.metrics.clear();
    }

    private static <T extends Annotation> void declareAsInterceptorBinding(Class<T> annotation, BeanManager manager, BeforeBeanDiscovery bbd) {
        AnnotatedType annotated = manager.createAnnotatedType(annotation);
        HashSet methods = new HashSet();
        for (AnnotatedMethod method : annotated.getMethods()) {
            methods.add(new AnnotatedMethodDecorator(method, (Annotation)NON_BINDING));
        }
        bbd.addInterceptorBinding(new AnnotatedTypeDecorator(annotated, (Annotation)INTERCEPTOR_BINDING, methods));
    }

    private static boolean hasInjectionPointMetadata(AnnotatedMember<?> member) {
        if (!(member instanceof AnnotatedMethod)) {
            return false;
        }
        AnnotatedMethod method = (AnnotatedMethod)member;
        for (AnnotatedParameter parameter : method.getParameters()) {
            if (!parameter.getBaseType().equals(InjectionPoint.class)) continue;
            return true;
        }
        return false;
    }

    private static <T> T getReference(BeanManager manager, Class<T> type) {
        return MetricCdiInjectionExtension.getReference(manager, type, manager.resolve(manager.getBeans(type, new Annotation[0])));
    }

    private static <T> T getReference(BeanManager manager, Type type, Bean<?> bean) {
        return (T)manager.getReference(bean, type, manager.createCreationalContext(bean));
    }
}

