/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.microprofile.metrics.runtime.exporters;

public class PrometheusUnit {
    private PrometheusUnit() {
    }

    public static String getBaseUnitAsPrometheusString(String unit) {
        String out;
        switch (unit) {
            case "bits": 
            case "kilobits": 
            case "megabits": 
            case "gigabits": 
            case "kibibits": 
            case "mebibits": 
            case "gibibits": 
            case "bytes": 
            case "kilobytes": 
            case "megabytes": 
            case "gigabytes": {
                out = "bytes";
                break;
            }
            case "nanoseconds": 
            case "microseconds": 
            case "milliseconds": 
            case "seconds": 
            case "minutes": 
            case "hours": 
            case "days": {
                out = "seconds";
                break;
            }
            default: {
                out = unit;
            }
        }
        return out;
    }

    public static Double scaleToBase(String unit, Double value) {
        Double out;
        switch (unit) {
            case "bits": {
                out = value / 8.0;
                break;
            }
            case "kilobits": {
                out = value * 1000.0 / 8.0;
                break;
            }
            case "megabits": {
                out = value * 1000000.0 / 8.0;
                break;
            }
            case "gigabits": {
                out = value * 1.0E9 / 8.0;
                break;
            }
            case "kibibits": {
                out = value * 128.0;
                break;
            }
            case "mebibits": {
                out = value * 1024.0 * 128.0;
                break;
            }
            case "gibibits": {
                out = value * 1024.0 * 1024.0 * 128.0;
                break;
            }
            case "bytes": {
                out = value;
                break;
            }
            case "kilobytes": {
                out = value * 1000.0;
                break;
            }
            case "megabytes": {
                out = value * 1000000.0;
                break;
            }
            case "gigabytes": {
                out = value * 1.0E9;
                break;
            }
            case "nanoseconds": {
                out = value / 1.0E9;
                break;
            }
            case "microseconds": {
                out = value / 1000000.0;
                break;
            }
            case "milliseconds": {
                out = value / 1000.0;
                break;
            }
            case "seconds": {
                out = value;
                break;
            }
            case "minutes": {
                out = value * 60.0;
                break;
            }
            case "hours": {
                out = value * 3600.0;
                break;
            }
            case "days": {
                out = value * 24.0 * 3600.0;
                break;
            }
            default: {
                out = value;
            }
        }
        return out;
    }
}

