/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.microprofile.metrics.runtime;

import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.HeaderValues;
import io.undertow.util.Headers;
import io.undertow.util.HttpString;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.jboss.logging.Logger;
import org.wildfly.swarm.microprofile.metrics.runtime.MetricRegistryFactory;
import org.wildfly.swarm.microprofile.metrics.runtime.exporters.Exporter;
import org.wildfly.swarm.microprofile.metrics.runtime.exporters.JsonExporter;
import org.wildfly.swarm.microprofile.metrics.runtime.exporters.JsonMetadataExporter;
import org.wildfly.swarm.microprofile.metrics.runtime.exporters.PrometheusExporter;

public class MetricsHttpHandler
implements HttpHandler {
    private static Logger LOG = Logger.getLogger((String)"org.wildfly.swarm.microprofile.metrics");
    private ThreadLocal<CountDownLatch> dispatched = new ThreadLocal();
    private HttpHandler next;

    public MetricsHttpHandler(HttpHandler next) {
        this.next = next;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        StringBuilder sb;
        String requestPath = exchange.getRequestPath();
        if (this.dispatched.get() != null && this.dispatched.get().getCount() == 1L) {
            this.next.handleRequest(exchange);
            this.dispatched.set(null);
            return;
        }
        if (!requestPath.startsWith("/metrics")) {
            this.next.handleRequest(exchange);
            return;
        }
        Exporter exporter = this.obtainExporter(exchange);
        if (exporter == null) {
            exchange.setStatusCode(406);
            exchange.setReasonPhrase("No exporter found for method " + exchange.getRequestMethod() + " and media type");
            return;
        }
        String scopePath = requestPath.substring(8);
        if (scopePath.startsWith("/")) {
            scopePath = scopePath.substring(1);
        }
        if (scopePath.endsWith("/")) {
            scopePath = scopePath.substring(0, scopePath.length() - 1);
        }
        if (scopePath.isEmpty()) {
            sb = exporter.exportAllScopes();
        } else if (scopePath.contains("/")) {
            String attribute = scopePath.substring(scopePath.indexOf(47) + 1);
            MetricRegistry.Type scope = this.getScopeFromPath(exchange, scopePath.substring(0, scopePath.indexOf(47)));
            if (scope == null) {
                exchange.setStatusCode(404);
                exchange.setReasonPhrase("Scope " + scopePath + " not found");
                return;
            }
            MetricRegistry registry = MetricRegistryFactory.get(scope);
            Map metricValuesMap = registry.getMetrics();
            if (!metricValuesMap.containsKey(attribute)) {
                exchange.setStatusCode(404);
                exchange.setReasonPhrase("Metric " + scopePath + " not found");
                return;
            }
            sb = exporter.exportOneMetric(scope, attribute);
        } else {
            MetricRegistry.Type scope = this.getScopeFromPath(exchange, scopePath);
            if (scope == null) {
                exchange.setStatusCode(404);
                exchange.setReasonPhrase("Scope " + scopePath + " not found");
                return;
            }
            MetricRegistry reg = MetricRegistryFactory.get(scope);
            if (reg.getMetadata().size() == 0) {
                exchange.setStatusCode(204);
                exchange.setReasonPhrase("No data in scope " + scopePath);
            }
            sb = exporter.exportOneScope(scope);
        }
        exchange.getResponseHeaders().put(Headers.CONTENT_TYPE, exporter.getContentType());
        this.provideCorsHeaders(exchange);
        exchange.getResponseHeaders().put(new HttpString("Access-Control-Max-Age"), "1209600");
        exchange.getResponseSender().send(sb.toString());
    }

    private void provideCorsHeaders(HttpServerExchange exchange) {
        exchange.getResponseHeaders().put(new HttpString("Access-Control-Allow-Origin"), "*");
        exchange.getResponseHeaders().put(new HttpString("Access-Control-Allow-Headers"), "origin, content-type, accept, authorization");
        exchange.getResponseHeaders().put(new HttpString("Access-Control-Allow-Credentials"), "true");
        exchange.getResponseHeaders().put(new HttpString("Access-Control-Allow-Methods"), "GET, POST, PUT, DELETE, OPTIONS, HEAD");
    }

    private MetricRegistry.Type getScopeFromPath(HttpServerExchange exchange, String scopePath) {
        MetricRegistry.Type scope;
        try {
            scope = MetricRegistry.Type.valueOf((String)scopePath.toUpperCase());
        }
        catch (IllegalArgumentException iae) {
            exchange.setStatusCode(404);
            exchange.setReasonPhrase("Bad scope requested: " + scopePath);
            return null;
        }
        return scope;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Exporter obtainExporter(HttpServerExchange exchange) {
        void var3_8;
        HeaderValues acceptHeaders = exchange.getRequestHeaders().get(Headers.ACCEPT);
        String method = exchange.getRequestMethod().toString();
        if (acceptHeaders == null) {
            if (!method.equals("GET")) return null;
            PrometheusExporter prometheusExporter = new PrometheusExporter();
            return var3_8;
        } else if (acceptHeaders.getFirst() != null && acceptHeaders.getFirst().startsWith("application/json")) {
            if (method.equals("GET")) {
                JsonExporter jsonExporter = new JsonExporter();
                return var3_8;
            } else {
                if (!method.equals("OPTIONS")) return null;
                JsonMetadataExporter jsonMetadataExporter = new JsonMetadataExporter();
            }
            return var3_8;
        } else {
            if (!method.equals("GET")) return null;
            PrometheusExporter prometheusExporter = new PrometheusExporter();
        }
        return var3_8;
    }
}

