/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.microprofile.metrics.deployment;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.inject.Inject;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.eclipse.microprofile.metrics.Counter;
import org.eclipse.microprofile.metrics.Gauge;
import org.eclipse.microprofile.metrics.Histogram;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.Meter;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.MetricType;
import org.eclipse.microprofile.metrics.Timer;
import org.eclipse.microprofile.metrics.annotation.Metric;
import org.eclipse.microprofile.metrics.annotation.RegistryType;
import org.wildfly.swarm.microprofile.metrics.api.RegistryFactory;
import org.wildfly.swarm.microprofile.metrics.deployment.MetricName;

@ApplicationScoped
public class AMetricRegistryFactory {
    @Inject
    private MetricName metricName;
    private ConcurrentMap<MetricRegistry.Type, MetricRegistry> registries;

    @PostConstruct
    void init() {
        this.registries = new ConcurrentHashMap<MetricRegistry.Type, MetricRegistry>();
    }

    @Default
    @Produces
    @RegistryType(type=MetricRegistry.Type.APPLICATION)
    public MetricRegistry getApplicationRegistry() {
        return this.get(MetricRegistry.Type.APPLICATION);
    }

    @Produces
    private <T> Gauge<T> gauge(final InjectionPoint ip) {
        return new Gauge<T>(){

            public T getValue() {
                return ((Gauge)AMetricRegistryFactory.this.getApplicationRegistry().getGauges().get(AMetricRegistryFactory.this.metricName.of(ip))).getValue();
            }
        };
    }

    @Produces
    public Counter getCounter(InjectionPoint ip) {
        return this.getApplicationRegistry().counter(this.getMetadata(ip, MetricType.COUNTER));
    }

    @Produces
    public Histogram getHistogram(InjectionPoint ip) {
        return this.getApplicationRegistry().histogram(this.getMetadata(ip, MetricType.HISTOGRAM));
    }

    @Produces
    public Meter getMeter(InjectionPoint ip) {
        return this.getApplicationRegistry().meter(this.getMetadata(ip, MetricType.METERED));
    }

    @Produces
    public Timer getTimer(InjectionPoint ip) {
        return this.getApplicationRegistry().timer(this.getMetadata(ip, MetricType.TIMER));
    }

    public MetricRegistry get(MetricRegistry.Type type) {
        return this.registries.computeIfAbsent(type, key -> {
            try {
                InitialContext context = new InitialContext();
                Object o = context.lookup("jboss/swarm/metrics");
                RegistryFactory factory = (RegistryFactory)o;
                return factory.get(type);
            }
            catch (NamingException e) {
                throw new IllegalStateException("RegistryFactory not found");
            }
        });
    }

    private Metadata getMetadata(InjectionPoint ip, MetricType type) {
        Metadata metadata = new Metadata(this.metricName.of(ip), type);
        Metric metric = (Metric)ip.getAnnotated().getAnnotation(Metric.class);
        if (metric != null) {
            if (!metric.unit().isEmpty()) {
                metadata.setUnit(metric.unit());
            }
            if (!metric.description().isEmpty()) {
                metadata.setDescription(metric.description());
            }
            if (!metric.displayName().isEmpty()) {
                metadata.setDisplayName(metric.displayName());
            }
            if (metric.tags().length > 0) {
                for (String tag : metric.tags()) {
                    metadata.addTags(tag);
                }
            }
        }
        return metadata;
    }
}

