/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.microprofile.metrics.runtime;

import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.jboss.logging.Logger;
import org.wildfly.swarm.microprofile.metrics.runtime.ExtendedMetadata;
import org.wildfly.swarm.microprofile.metrics.runtime.MetricRegistryFactory;

public class JmxWorker {
    private static final String PLACEHOLDER = "%s";
    private static MBeanServer mbs;
    private static JmxWorker worker;
    private static Logger LOG;

    private JmxWorker() {
    }

    public static JmxWorker instance() {
        if (worker == null) {
            worker = new JmxWorker();
            mbs = ManagementFactory.getPlatformMBeanServer();
        }
        return worker;
    }

    public Map<String, Double> getMetrics(MetricRegistry.Type scope) {
        Map metadataMap = MetricRegistryFactory.get(scope).getMetadata();
        HashMap<String, Double> outcome = new HashMap<String, Double>();
        for (Metadata m : metadataMap.values()) {
            if (!(m instanceof ExtendedMetadata)) {
                throw new IllegalStateException("Not extended Metadata " + m);
            }
            ExtendedMetadata em = (ExtendedMetadata)m;
            Double val = this.getValue(em.getMbean()).doubleValue();
            outcome.put(em.getName(), val);
        }
        return outcome;
    }

    public Number getValue(String mbeanExpression) {
        if (mbeanExpression == null) {
            throw new IllegalArgumentException("MBean Expression is null");
        }
        if (!mbeanExpression.contains("/")) {
            throw new IllegalArgumentException(mbeanExpression);
        }
        int slashIndex = mbeanExpression.indexOf(47);
        String mbean = mbeanExpression.substring(0, slashIndex);
        String attName = mbeanExpression.substring(slashIndex + 1);
        String subItem = null;
        if (attName.contains("#")) {
            int hashIndex = attName.indexOf(35);
            subItem = attName.substring(hashIndex + 1);
            attName = attName.substring(0, hashIndex);
        }
        try {
            ObjectName objectName = new ObjectName(mbean);
            Object attribute = mbs.getAttribute(objectName, attName);
            if (attribute instanceof Number) {
                return (Number)attribute;
            }
            if (attribute instanceof CompositeData) {
                CompositeData compositeData = (CompositeData)attribute;
                return (Number)compositeData.get(subItem);
            }
            throw new IllegalArgumentException(mbeanExpression);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    void expandMultiValueEntries(List<ExtendedMetadata> entries) {
        ArrayList<ExtendedMetadata> result = new ArrayList<ExtendedMetadata>();
        ArrayList<ExtendedMetadata> toBeRemoved = new ArrayList<ExtendedMetadata>(entries.size());
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        for (ExtendedMetadata entry : entries) {
            if (!entry.isMulti()) continue;
            String name = entry.getMbean().replace(PLACEHOLDER, "*");
            int slashIndex = name.indexOf(47);
            if (slashIndex < 0) {
                toBeRemoved.add(entry);
                continue;
            }
            String queryableName = name.substring(0, slashIndex);
            String attName = name.substring(slashIndex + 1);
            try {
                ObjectName objectName = new ObjectName(queryableName);
                String keyHolder = this.findKeyForValueToBeReplaced(objectName);
                Set<ObjectName> objNames = mbs.queryNames(objectName, null);
                for (ObjectName oName : objNames) {
                    String keyValue = oName.getKeyPropertyList().get(keyHolder);
                    String newName = entry.getName();
                    if (!newName.contains(PLACEHOLDER)) {
                        LOG.warn((Object)("Name [" + newName + "] did not contain a %s, no replacement will be done, check the configuration"));
                    }
                    newName = newName.replace(PLACEHOLDER, keyValue);
                    String newDisplayName = entry.getDisplayName().replace(PLACEHOLDER, keyValue);
                    String newDescription = entry.getDescription().replace(PLACEHOLDER, keyValue);
                    ExtendedMetadata newEntry = new ExtendedMetadata(newName, newDisplayName, newDescription, entry.getTypeRaw(), entry.getUnit());
                    String newObjectName = oName.getCanonicalName() + "/" + attName;
                    newEntry.setMbean(newObjectName);
                    result.add(newEntry);
                }
                toBeRemoved.add(entry);
            }
            catch (MalformedObjectNameException e) {
                e.printStackTrace();
            }
        }
        entries.removeAll(toBeRemoved);
        entries.addAll(result);
        LOG.info((Object)("Converted [" + toBeRemoved.size() + "] config entries and added [" + result.size() + "] replacements"));
    }

    private String findKeyForValueToBeReplaced(ObjectName objectName) {
        String keyHolder = null;
        Hashtable<String, String> keyPropList = objectName.getKeyPropertyList();
        for (String key : keyPropList.keySet()) {
            if (!keyPropList.get(key).equals("*")) continue;
            keyHolder = key;
        }
        return keyHolder;
    }

    static {
        LOG = Logger.getLogger((String)"org.wildfly.swarm.microprofile.metrics");
    }
}

