/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.microprofile.metrics.runtime;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.wildfly.swarm.microprofile.metrics.runtime.MetricsRegistryImpl;

public class MetricRegistryFactory {
    private static final Map<MetricRegistry.Type, MetricRegistry> registries = new HashMap<MetricRegistry.Type, MetricRegistry>();

    private MetricRegistryFactory() {
    }

    public static MetricRegistry getApplicationRegistry() {
        return MetricRegistryFactory.get(MetricRegistry.Type.APPLICATION);
    }

    public static MetricRegistry getBaseRegistry() {
        return MetricRegistryFactory.get(MetricRegistry.Type.BASE);
    }

    public static MetricRegistry getVendorRegistry() {
        return MetricRegistryFactory.get(MetricRegistry.Type.VENDOR);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MetricRegistry get(MetricRegistry.Type type) {
        Map<MetricRegistry.Type, MetricRegistry> map = registries;
        synchronized (map) {
            if (registries.get(type) == null) {
                MetricsRegistryImpl result = new MetricsRegistryImpl();
                registries.put(type, result);
            }
        }
        return registries.get(type);
    }
}

