/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.microprofile.metrics.deployment;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.Collections;
import javax.enterprise.inject.Vetoed;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.annotation.Counted;
import org.eclipse.microprofile.metrics.annotation.Gauge;
import org.eclipse.microprofile.metrics.annotation.Metered;
import org.eclipse.microprofile.metrics.annotation.Timed;
import org.wildfly.swarm.microprofile.metrics.deployment.MetricName;
import org.wildfly.swarm.microprofile.metrics.deployment.SeMetricName;

@Vetoed
class MetricResolver {
    private MetricName metricName = new SeMetricName(Collections.emptySet());

    MetricResolver() {
    }

    <E extends Member & AnnotatedElement> Of<Counted> counted(Class<?> topClass, E element) {
        return this.resolverOf(topClass, element, (Class)Counted.class);
    }

    Of<Gauge> gauge(Class<?> topClass, Method method) {
        return this.resolverOf(topClass, method, Gauge.class);
    }

    <E extends Member & AnnotatedElement> Of<Metered> metered(Class<?> topClass, E element) {
        return this.resolverOf(topClass, element, (Class)Metered.class);
    }

    <E extends Member & AnnotatedElement> Of<Timed> timed(Class<?> bean, E element) {
        return this.resolverOf(bean, element, (Class)Timed.class);
    }

    private <E extends Member & AnnotatedElement, T extends Annotation> Of<T> resolverOf(Class<?> bean, E element, Class<T> metric) {
        if (((AnnotatedElement)element).isAnnotationPresent(metric)) {
            return this.elementResolverOf(element, metric);
        }
        return this.beanResolverOf(element, metric, bean);
    }

    private <E extends Member & AnnotatedElement, T extends Annotation> Of<T> elementResolverOf(E element, Class<T> metric) {
        T annotation = ((AnnotatedElement)element).getAnnotation(metric);
        String name = this.metricName(element, (Class<? extends Annotation>)metric, this.metricName((Annotation)annotation), this.isMetricAbsolute((Annotation)annotation));
        return new DoesHaveMetric((Annotation)annotation, name, null);
    }

    private <E extends Member & AnnotatedElement, T extends Annotation> Of<T> beanResolverOf(E element, Class<T> metric, Class<?> bean) {
        if (bean.isAnnotationPresent(metric)) {
            T annotation = bean.getAnnotation(metric);
            String name = this.metricName(bean, element, (Class<? extends Annotation>)metric, this.metricName((Annotation)annotation), this.isMetricAbsolute((Annotation)annotation));
            return new DoesHaveMetric((Annotation)annotation, name, null);
        }
        if (bean.getSuperclass() != null) {
            return this.beanResolverOf(element, metric, bean.getSuperclass());
        }
        return new DoesNotHaveMetric();
    }

    private <E extends Member & AnnotatedElement> String metricName(E element, Class<? extends Annotation> type, String name, boolean absolute) {
        String metric = name.isEmpty() ? this.defaultName(element, type) : this.metricName.of(name);
        return absolute ? metric : MetricRegistry.name(element.getDeclaringClass(), (String[])new String[]{metric});
    }

    private <E extends Member & AnnotatedElement> String metricName(Class<?> bean, E element, Class<? extends Annotation> type, String name, boolean absolute) {
        String metric = name.isEmpty() ? bean.getSimpleName() : this.metricName.of(name);
        return absolute ? MetricRegistry.name((String)metric, (String[])new String[]{this.defaultName(element, type)}) : MetricRegistry.name((String)bean.getPackage().getName(), (String[])new String[]{metric, this.defaultName(element, type)});
    }

    private <E extends Member & AnnotatedElement> String defaultName(E element, Class<? extends Annotation> type) {
        return this.memberName(element);
    }

    private String memberName(Member member) {
        if (member instanceof Constructor) {
            return member.getDeclaringClass().getSimpleName();
        }
        return member.getName();
    }

    private String metricName(Annotation annotation) {
        if (Counted.class.isInstance(annotation)) {
            return ((Counted)annotation).name();
        }
        if (Gauge.class.isInstance(annotation)) {
            return ((Gauge)annotation).name();
        }
        if (Metered.class.isInstance(annotation)) {
            return ((Metered)annotation).name();
        }
        if (Timed.class.isInstance(annotation)) {
            return ((Timed)annotation).name();
        }
        throw new IllegalArgumentException("Unsupported Metrics forMethod [" + annotation.getClass().getName() + "]");
    }

    private boolean isMetricAbsolute(Annotation annotation) {
        if (Counted.class.isInstance(annotation)) {
            return ((Counted)annotation).absolute();
        }
        if (Gauge.class.isInstance(annotation)) {
            return ((Gauge)annotation).absolute();
        }
        if (Metered.class.isInstance(annotation)) {
            return ((Metered)annotation).absolute();
        }
        if (Timed.class.isInstance(annotation)) {
            return ((Timed)annotation).absolute();
        }
        throw new IllegalArgumentException("Unsupported Metrics forMethod [" + annotation.getClass().getName() + "]");
    }

    @Vetoed
    private static final class DoesNotHaveMetric<T extends Annotation>
    implements Of<T> {
        private DoesNotHaveMetric() {
        }

        @Override
        public boolean isPresent() {
            return false;
        }

        @Override
        public String metricName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public T metricAnnotation() {
            throw new UnsupportedOperationException();
        }
    }

    private static final class DoesHaveMetric<T extends Annotation>
    implements Of<T> {
        private final T annotation;
        private final String name;

        private DoesHaveMetric(T annotation, String name) {
            this.annotation = annotation;
            this.name = name;
        }

        @Override
        public boolean isPresent() {
            return true;
        }

        @Override
        public String metricName() {
            return this.name;
        }

        @Override
        public T metricAnnotation() {
            return this.annotation;
        }

        /* synthetic */ DoesHaveMetric(Annotation x0, String x1, 1 x2) {
            this(x0, x1);
        }
    }

    static interface Of<T extends Annotation> {
        public boolean isPresent();

        public String metricName();

        public T metricAnnotation();
    }
}

