/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.microprofile.metrics.runtime;

import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import javax.enterprise.inject.Vetoed;
import org.eclipse.microprofile.metrics.Counter;
import org.eclipse.microprofile.metrics.Gauge;
import org.eclipse.microprofile.metrics.Histogram;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.Meter;
import org.eclipse.microprofile.metrics.Metric;
import org.eclipse.microprofile.metrics.MetricFilter;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.MetricType;
import org.eclipse.microprofile.metrics.Timer;
import org.jboss.logging.Logger;
import org.wildfly.swarm.microprofile.metrics.runtime.app.CounterImpl;
import org.wildfly.swarm.microprofile.metrics.runtime.app.ExponentiallyDecayingReservoir;
import org.wildfly.swarm.microprofile.metrics.runtime.app.HistogramImpl;
import org.wildfly.swarm.microprofile.metrics.runtime.app.MeterImpl;
import org.wildfly.swarm.microprofile.metrics.runtime.app.TimerImpl;

@Vetoed
public class MetricsRegistryImpl
extends MetricRegistry {
    private static final Logger LOGGER = Logger.getLogger(MetricsRegistryImpl.class);
    private Map<String, Metadata> metadataMap = new HashMap<String, Metadata>();
    private Map<String, Metric> metricMap = new ConcurrentHashMap<String, Metric>();

    public <T extends Metric> T register(String name, T metric) throws IllegalArgumentException {
        MetricType type;
        if (this.metricMap.keySet().contains(name)) {
            throw new IllegalArgumentException("A metric with name " + name + " already exists");
        }
        Class<?> metricCls = metric.getClass();
        if (metricCls.getName().contains("Lambda")) {
            String tname = metricCls.getGenericInterfaces()[0].getTypeName();
            tname = tname.substring(tname.lastIndexOf(46) + 1);
            tname = tname.toLowerCase();
            type = MetricType.from((String)tname);
        } else {
            type = metricCls.isAnonymousClass() ? MetricType.from(metricCls.getInterfaces().length == 0 ? metricCls.getSuperclass().getInterfaces()[0] : metricCls.getInterfaces()[0]) : (!metricCls.isInterface() ? MetricType.from(metricCls.getInterfaces()[0]) : MetricType.from(metricCls));
        }
        Metadata m = new Metadata(name, type);
        this.metricMap.put(name, metric);
        this.metadataMap.put(name, m);
        return metric;
    }

    public <T extends Metric> T register(String name, T metric, Metadata metadata) throws IllegalArgumentException {
        metadata.setName(name);
        return this.register(metadata, metric);
    }

    public <T extends Metric> T register(Metadata metadata, T metric) throws IllegalArgumentException {
        boolean reusableFlag;
        String name = metadata.getName();
        if (name == null) {
            throw new IllegalArgumentException("Metric name must not be null");
        }
        Metadata existingMetadata = this.metadataMap.get(name);
        boolean bl = reusableFlag = existingMetadata == null || existingMetadata.isReusable();
        if (metadata.getTypeRaw().equals((Object)MetricType.GAUGE)) {
            reusableFlag = false;
        }
        if (this.metricMap.keySet().contains(metadata.getName()) && !reusableFlag) {
            throw new IllegalArgumentException("A metric with name " + metadata.getName() + " already exists");
        }
        if (existingMetadata != null && !existingMetadata.getTypeRaw().equals((Object)metadata.getTypeRaw())) {
            throw new IllegalArgumentException("Passed metric type does not match existing type");
        }
        this.metricMap.put(name, metric);
        this.metadataMap.put(name, metadata);
        return metric;
    }

    public Counter counter(String name) {
        return this.counter(new Metadata(name, MetricType.COUNTER));
    }

    public Counter counter(Metadata metadata) {
        return (Counter)this.get(metadata, MetricType.COUNTER);
    }

    public Histogram histogram(String name) {
        return this.histogram(new Metadata(name, MetricType.HISTOGRAM));
    }

    public Histogram histogram(Metadata metadata) {
        return (Histogram)this.get(metadata, MetricType.HISTOGRAM);
    }

    public Meter meter(String s) {
        return this.meter(new Metadata(s, MetricType.METERED));
    }

    public Meter meter(Metadata metadata) {
        return (Meter)this.get(metadata, MetricType.METERED);
    }

    private <T extends Metric> T get(Metadata metadata, MetricType type) {
        String name = metadata.getName();
        LOGGER.debugf("Get metric [name: %s, type: %s]", (Object)name, (Object)type);
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("Name must not be null or empty");
        }
        if (!this.metadataMap.containsKey(name)) {
            Object m;
            switch (type) {
                case COUNTER: {
                    m = new CounterImpl();
                    break;
                }
                case GAUGE: {
                    throw new IllegalArgumentException("Gauge " + name + " was not registered, this should not happen");
                }
                case METERED: {
                    m = new MeterImpl();
                    break;
                }
                case HISTOGRAM: {
                    m = new HistogramImpl(new ExponentiallyDecayingReservoir());
                    break;
                }
                case TIMER: {
                    m = new TimerImpl(new ExponentiallyDecayingReservoir());
                    break;
                }
                default: {
                    throw new IllegalStateException("Must not happen");
                }
            }
            LOGGER.infof("Register metric [name: %s, type: %s]", (Object)name, (Object)type);
            this.register(metadata, m);
        } else if (!this.metadataMap.get(name).getTypeRaw().equals((Object)metadata.getTypeRaw())) {
            throw new IllegalArgumentException("Type of existing previously registered metric " + name + " does not match passed type");
        }
        return (T)this.metricMap.get(name);
    }

    public Timer timer(String s) {
        return this.timer(new Metadata(s, MetricType.TIMER));
    }

    public Timer timer(Metadata metadata) {
        return (Timer)this.get(metadata, MetricType.TIMER);
    }

    public boolean remove(String metricName) {
        if (this.metricMap.containsKey(metricName)) {
            LOGGER.infof("Remove metric [name: %s]", (Object)metricName);
            this.metricMap.remove(metricName);
            this.metadataMap.remove(metricName);
            return true;
        }
        return false;
    }

    public void removeMatching(MetricFilter metricFilter) {
        for (Map.Entry<String, Metric> entry : this.metricMap.entrySet()) {
            if (!metricFilter.matches(entry.getKey(), entry.getValue())) continue;
            this.remove(entry.getKey());
        }
    }

    public SortedSet<String> getNames() {
        return new TreeSet<String>(this.metricMap.keySet());
    }

    public SortedMap<String, Gauge> getGauges() {
        return this.getGauges(MetricFilter.ALL);
    }

    public SortedMap<String, Gauge> getGauges(MetricFilter metricFilter) {
        return this.getMetrics(MetricType.GAUGE, metricFilter);
    }

    public SortedMap<String, Counter> getCounters() {
        return this.getCounters(MetricFilter.ALL);
    }

    public SortedMap<String, Counter> getCounters(MetricFilter metricFilter) {
        return this.getMetrics(MetricType.COUNTER, metricFilter);
    }

    public SortedMap<String, Histogram> getHistograms() {
        return this.getHistograms(MetricFilter.ALL);
    }

    public SortedMap<String, Histogram> getHistograms(MetricFilter metricFilter) {
        return this.getMetrics(MetricType.HISTOGRAM, metricFilter);
    }

    public SortedMap<String, Meter> getMeters() {
        return this.getMeters(MetricFilter.ALL);
    }

    public SortedMap<String, Meter> getMeters(MetricFilter metricFilter) {
        return this.getMetrics(MetricType.METERED, metricFilter);
    }

    public SortedMap<String, Timer> getTimers() {
        return this.getTimers(MetricFilter.ALL);
    }

    public SortedMap<String, Timer> getTimers(MetricFilter metricFilter) {
        return this.getMetrics(MetricType.TIMER, metricFilter);
    }

    public Map<String, Metric> getMetrics() {
        return new HashMap<String, Metric>(this.metricMap);
    }

    private <T extends Metric> SortedMap<String, T> getMetrics(MetricType type, MetricFilter filter) {
        TreeMap<String, Metric> out = new TreeMap<String, Metric>();
        for (Map.Entry<String, Metric> entry : this.metricMap.entrySet()) {
            if (!filter.matches(entry.getKey(), entry.getValue())) continue;
            out.put(entry.getKey(), entry.getValue());
        }
        return out;
    }

    public Map<String, Metadata> getMetadata() {
        return new HashMap<String, Metadata>(this.metadataMap);
    }
}

