/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.microprofile.metrics.deployment;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.interceptor.AroundConstruct;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;
import org.eclipse.microprofile.metrics.Gauge;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.Metric;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.MetricType;
import org.eclipse.microprofile.metrics.annotation.Counted;
import org.eclipse.microprofile.metrics.annotation.Metered;
import org.eclipse.microprofile.metrics.annotation.Timed;
import org.jboss.logging.Logger;
import org.wildfly.swarm.microprofile.metrics.deployment.MetricResolver;
import org.wildfly.swarm.microprofile.metrics.deployment.MetricsBinding;

@Interceptor
@MetricsBinding
@Priority(value=1000)
class MetricsInterceptor {
    private static final Logger LOGGER = Logger.getLogger(MetricsInterceptor.class);
    private final MetricRegistry registry;
    private final MetricResolver resolver;

    @Inject
    private MetricsInterceptor(MetricRegistry registry) {
        this.registry = registry;
        this.resolver = new MetricResolver();
    }

    @AroundConstruct
    private Object metrics(InvocationContext context) throws Exception {
        Class bean = context.getConstructor().getDeclaringClass();
        LOGGER.infof("MetricsInterceptor, bean=%s\n", bean);
        this.registerMetrics(bean, context.getConstructor());
        Class type = bean;
        do {
            for (Method method : type.getDeclaredMethods()) {
                if (method.isSynthetic() || Modifier.isPrivate(method.getModifiers())) continue;
                this.registerMetrics(bean, method);
            }
        } while (!Object.class.equals(type = type.getSuperclass()));
        Object target = context.proceed();
        type = bean;
        do {
            for (Method method : type.getDeclaredMethods()) {
                MetricResolver.Of<org.eclipse.microprofile.metrics.annotation.Gauge> gauge = this.resolver.gauge(bean, method);
                if (!gauge.isPresent()) continue;
                org.eclipse.microprofile.metrics.annotation.Gauge g = gauge.metricAnnotation();
                Metadata metadata = this.getMetadata(gauge.metricName(), g.unit(), g.description(), g.displayName(), MetricType.GAUGE, g.tags());
                this.registry.register(metadata, (Metric)new ForwardingGauge(method, context.getTarget()));
            }
        } while (!Object.class.equals(type = type.getSuperclass()));
        return target;
    }

    private <E extends Member & AnnotatedElement> void registerMetrics(Class<?> bean, E element) {
        MetricResolver.Of<Timed> timed;
        MetricResolver.Of<Metered> metered;
        MetricResolver.Of<Counted> counted = this.resolver.counted(bean, element);
        if (counted.isPresent()) {
            Counted t = counted.metricAnnotation();
            Metadata metadata = this.getMetadata(counted.metricName(), t.unit(), t.description(), t.displayName(), MetricType.COUNTER, t.tags());
            this.registry.counter(metadata);
        }
        if ((metered = this.resolver.metered(bean, element)).isPresent()) {
            Metered t = metered.metricAnnotation();
            Metadata metadata = this.getMetadata(metered.metricName(), t.unit(), t.description(), t.displayName(), MetricType.METERED, t.tags());
            this.registry.meter(metadata);
        }
        if ((timed = this.resolver.timed(bean, element)).isPresent()) {
            Timed t = timed.metricAnnotation();
            Metadata metadata = this.getMetadata(timed.metricName(), t.unit(), t.description(), t.displayName(), MetricType.TIMER, t.tags());
            this.registry.timer(metadata);
        }
    }

    private Metadata getMetadata(String name, String unit, String description, String displayName, MetricType type, String ... tags) {
        Metadata metadata = new Metadata(name, type);
        if (!unit.isEmpty()) {
            metadata.setUnit(unit);
        }
        if (!description.isEmpty()) {
            metadata.setDescription(description);
        }
        if (!displayName.isEmpty()) {
            metadata.setDisplayName(displayName);
        }
        if (tags != null && tags.length > 0) {
            for (String tag : tags) {
                metadata.addTags(tag);
            }
        }
        return metadata;
    }

    private static Object invokeMethod(Method method, Object object) {
        try {
            return method.invoke(object, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException cause) {
            throw new IllegalStateException("Error while calling method [" + method + "]", cause);
        }
    }

    private static final class ForwardingGauge
    implements Gauge<Object> {
        private final Method method;
        private final Object object;

        private ForwardingGauge(Method method, Object object) {
            this.method = method;
            this.object = object;
            method.setAccessible(true);
        }

        public Object getValue() {
            return MetricsInterceptor.invokeMethod(this.method, this.object);
        }
    }
}

