/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.microprofile.metrics.runtime.exporters;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.microprofile.metrics.Counter;
import org.eclipse.microprofile.metrics.Gauge;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.Metered;
import org.eclipse.microprofile.metrics.Metric;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.Snapshot;
import org.jboss.logging.Logger;
import org.wildfly.swarm.microprofile.metrics.runtime.MetricRegistryFactory;
import org.wildfly.swarm.microprofile.metrics.runtime.app.HistogramImpl;
import org.wildfly.swarm.microprofile.metrics.runtime.app.MeterImpl;
import org.wildfly.swarm.microprofile.metrics.runtime.app.TimerImpl;
import org.wildfly.swarm.microprofile.metrics.runtime.exporters.Exporter;
import org.wildfly.swarm.microprofile.metrics.runtime.exporters.ExporterUtil;
import org.wildfly.swarm.microprofile.metrics.runtime.exporters.Helper;

public class JsonExporter
implements Exporter {
    private static Logger LOG = Logger.getLogger((String)"org.wildfly.swarm.microprofile.metrics");
    private static final String COMMA_LF = ",\n";
    private static final String LF = "\n";

    @Override
    public StringBuilder exportOneScope(MetricRegistry.Type scope) {
        StringBuilder sb = new StringBuilder();
        this.getMetricsForAScope(sb, scope);
        return sb;
    }

    private void getMetricsForAScope(StringBuilder sb, MetricRegistry.Type scope) {
        MetricRegistry registry = MetricRegistryFactory.get(scope);
        Map metricMap = registry.getMetrics();
        Map metadataMap = registry.getMetadata();
        sb.append("{\n");
        this.writeMetricsForMap(sb, metricMap, metadataMap);
        sb.append("}");
    }

    private void writeMetricsForMap(StringBuilder sb, Map<String, Metric> metricMap, Map<String, Metadata> metadataMap) {
        Iterator<Map.Entry<String, Metric>> iterator = metricMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Metric> entry = iterator.next();
            String key = entry.getKey();
            Metric value = entry.getValue();
            Metadata metadata = metadataMap.get(key);
            if (metadata == null) {
                throw new IllegalArgumentException("MD is null for " + key);
            }
            switch (metadata.getTypeRaw()) {
                case GAUGE: 
                case COUNTER: {
                    Number val = this.getValueFromMetric(value, key);
                    sb.append("  ").append('\"').append(key).append('\"').append(" : ").append(val);
                    break;
                }
                case METERED: {
                    MeterImpl meter = (MeterImpl)value;
                    this.writeStartLine(sb, key);
                    this.writeMeterValues(sb, (Metered)meter);
                    this.writeEndLine(sb);
                    break;
                }
                case TIMER: {
                    TimerImpl timer = (TimerImpl)value;
                    this.writeStartLine(sb, key);
                    this.writeTimerValues(sb, timer, metadata.getUnit());
                    this.writeEndLine(sb);
                    break;
                }
                case HISTOGRAM: {
                    HistogramImpl hist = (HistogramImpl)value;
                    this.writeStartLine(sb, key);
                    sb.append("    \"count\": ").append(hist.getCount()).append(COMMA_LF);
                    this.writeSnapshotValues(sb, hist.getSnapshot());
                    this.writeEndLine(sb);
                    break;
                }
                default: {
                    LOG.error((Object)("JSE, Not yet supported: " + metadata));
                }
            }
            if (iterator.hasNext()) {
                sb.append(',');
            }
            sb.append(LF);
        }
    }

    private void writeEndLine(StringBuilder sb) {
        sb.append("  }");
    }

    private void writeStartLine(StringBuilder sb, String key) {
        sb.append("  ").append('\"').append(key).append('\"').append(" : ").append("{\n");
    }

    private void writeMeterValues(StringBuilder sb, Metered meter) {
        sb.append("    \"count\": ").append(meter.getCount()).append(COMMA_LF);
        sb.append("    \"meanRate\": ").append(meter.getMeanRate()).append(COMMA_LF);
        sb.append("    \"oneMinRate\": ").append(meter.getOneMinuteRate()).append(COMMA_LF);
        sb.append("    \"fiveMinRate\": ").append(meter.getFiveMinuteRate()).append(COMMA_LF);
        sb.append("    \"fifteenMinRate\": ").append(meter.getFifteenMinuteRate()).append(LF);
    }

    private void writeTimerValues(StringBuilder sb, TimerImpl timer, String unit) {
        this.writeSnapshotValues(sb, timer.getSnapshot(), unit);
        sb.setLength(sb.length() - 1);
        sb.append(COMMA_LF);
        this.writeMeterValues(sb, timer.getMeter());
    }

    private void writeSnapshotValues(StringBuilder sb, Snapshot snapshot) {
        sb.append("    \"p50\": ").append(snapshot.getMedian()).append(COMMA_LF);
        sb.append("    \"p75\": ").append(snapshot.get75thPercentile()).append(COMMA_LF);
        sb.append("    \"p95\": ").append(snapshot.get95thPercentile()).append(COMMA_LF);
        sb.append("    \"p98\": ").append(snapshot.get98thPercentile()).append(COMMA_LF);
        sb.append("    \"p99\": ").append(snapshot.get99thPercentile()).append(COMMA_LF);
        sb.append("    \"p999\": ").append(snapshot.get999thPercentile()).append(COMMA_LF);
        sb.append("    \"min\": ").append(snapshot.getMin()).append(COMMA_LF);
        sb.append("    \"mean\": ").append(snapshot.getMean()).append(COMMA_LF);
        sb.append("    \"max\": ").append(snapshot.getMax()).append(COMMA_LF);
        sb.append("    \"stddev\": ").append(snapshot.getStdDev()).append(LF);
    }

    private void writeSnapshotValues(StringBuilder sb, Snapshot snapshot, String unit) {
        sb.append("    \"p50\": ").append(this.toBase(snapshot.getMedian(), unit)).append(COMMA_LF);
        sb.append("    \"p75\": ").append(this.toBase(snapshot.get75thPercentile(), unit)).append(COMMA_LF);
        sb.append("    \"p95\": ").append(this.toBase(snapshot.get95thPercentile(), unit)).append(COMMA_LF);
        sb.append("    \"p98\": ").append(this.toBase(snapshot.get98thPercentile(), unit)).append(COMMA_LF);
        sb.append("    \"p99\": ").append(this.toBase(snapshot.get99thPercentile(), unit)).append(COMMA_LF);
        sb.append("    \"p999\": ").append(this.toBase(snapshot.get999thPercentile(), unit)).append(COMMA_LF);
        sb.append("    \"min\": ").append(this.toBase(snapshot.getMin(), unit)).append(COMMA_LF);
        sb.append("    \"mean\": ").append(this.toBase(snapshot.getMean(), unit)).append(COMMA_LF);
        sb.append("    \"max\": ").append(this.toBase(snapshot.getMax(), unit)).append(COMMA_LF);
        sb.append("    \"stddev\": ").append(this.toBase(snapshot.getStdDev(), unit)).append(LF);
    }

    private Number toBase(Number count, String unit) {
        return ExporterUtil.convertNanosTo(count.doubleValue(), unit);
    }

    private Number getValueFromMetric(Metric theMetric, String name) {
        if (theMetric instanceof Gauge) {
            Number value = (Number)((Gauge)theMetric).getValue();
            if (value != null) {
                return value;
            }
            LOG.warn((Object)("Value is null for " + name));
            return -142.142;
        }
        if (theMetric instanceof Counter) {
            return ((Counter)theMetric).getCount();
        }
        LOG.error((Object)("Not yet supported metric: " + theMetric.getClass().getName()));
        return -42.42;
    }

    @Override
    public StringBuilder exportAllScopes() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        MetricRegistry.Type[] values = MetricRegistry.Type.values();
        int totalNonEmptyScopes = Helper.countNonEmptyScopes();
        int scopes = 0;
        for (int i = 0; i < values.length; ++i) {
            MetricRegistry.Type scope = values[i];
            MetricRegistry registry = MetricRegistryFactory.get(scope);
            if (registry.getNames().size() <= 0) continue;
            sb.append('\"').append(scope.getName().toLowerCase()).append('\"').append(" :\n");
            this.getMetricsForAScope(sb, scope);
            sb.append(LF);
            if (++scopes >= totalNonEmptyScopes) continue;
            sb.append(',');
        }
        sb.append("}");
        return sb;
    }

    @Override
    public StringBuilder exportOneMetric(MetricRegistry.Type scope, String metricName) {
        MetricRegistry registry = MetricRegistryFactory.get(scope);
        Map metricMap = registry.getMetrics();
        Map metadataMap = registry.getMetadata();
        Metric m = (Metric)metricMap.get(metricName);
        HashMap<String, Metric> outMap = new HashMap<String, Metric>(1);
        outMap.put(metricName, m);
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        this.writeMetricsForMap(sb, outMap, metadataMap);
        sb.append("}");
        sb.append(LF);
        return sb;
    }

    @Override
    public String getContentType() {
        return "application/json";
    }
}

