/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.microprofile.metrics.deployment;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Member;
import javax.annotation.Priority;
import javax.enterprise.inject.Intercepted;
import javax.enterprise.inject.spi.Bean;
import javax.inject.Inject;
import javax.interceptor.AroundConstruct;
import javax.interceptor.AroundInvoke;
import javax.interceptor.AroundTimeout;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;
import org.eclipse.microprofile.metrics.Meter;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.annotation.Metered;
import org.wildfly.swarm.microprofile.metrics.deployment.MetricResolver;

@Metered
@Interceptor
@Priority(value=1010)
class MeteredInterceptor {
    private final Bean<?> bean;
    private final MetricRegistry registry;
    private final MetricResolver resolver;

    @Inject
    private MeteredInterceptor(@Intercepted Bean<?> bean, MetricRegistry registry) {
        this.bean = bean;
        this.registry = registry;
        this.resolver = new MetricResolver();
    }

    @AroundConstruct
    private Object meteredConstructor(InvocationContext context) throws Exception {
        return this.meteredCallable(context, context.getConstructor());
    }

    @AroundInvoke
    private Object meteredMethod(InvocationContext context) throws Exception {
        return this.meteredCallable(context, context.getMethod());
    }

    @AroundTimeout
    private Object meteredTimeout(InvocationContext context) throws Exception {
        return this.meteredCallable(context, context.getMethod());
    }

    private <E extends Member & AnnotatedElement> Object meteredCallable(InvocationContext context, E element) throws Exception {
        String name = this.resolver.metered(this.bean.getBeanClass(), element).metricName();
        Meter meter = (Meter)this.registry.getMetrics().get(name);
        if (meter == null) {
            throw new IllegalStateException("No meter with name [" + name + "] found in registry [" + this.registry + "]");
        }
        meter.mark();
        return context.proceed();
    }
}

