/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.microprofile.metrics.runtime.exporters;

public class ExporterUtil {
    public static final long NANOS_PER_MICROSECOND = 1000L;
    public static final long NANOS_PER_MILLI = 1000000L;
    public static final long NANOS_PER_SECOND = 1000000000L;
    public static final long NANOS_PER_MINUTE = 60000000000L;
    public static final long NANOS_PER_HOUR = 3600000000000L;
    public static final long NANOS_PER_DAY = 86400000000000L;

    private ExporterUtil() {
    }

    public static Double convertNanosTo(Double value, String unit) {
        Double out;
        switch (unit) {
            case "nanoseconds": {
                out = value;
                break;
            }
            case "microseconds": {
                out = value / 1000.0;
                break;
            }
            case "milliseconds": {
                out = value / 1000000.0;
                break;
            }
            case "seconds": {
                out = value / 1.0E9;
                break;
            }
            case "minutes": {
                out = value / 6.0E10;
                break;
            }
            case "hours": {
                out = value / 3.6E12;
                break;
            }
            case "days": {
                out = value / 8.64E13;
                break;
            }
            default: {
                out = value;
            }
        }
        return out;
    }
}

