/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.microprofile.openapi.runtime;

import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.wildfly.swarm.spi.api.Customizer;
import org.wildfly.swarm.spi.runtime.annotations.Post;
import org.wildfly.swarm.undertow.UndertowFraction;

@Post
@ApplicationScoped
public class OpenApiUndertowFilterCustomizer
implements Customizer {
    @Inject
    Instance<UndertowFraction> undertowFractionInstance;

    public void customize() {
        UndertowFraction undertow;
        if (!this.undertowFractionInstance.isUnsatisfied()) {
            undertow = (UndertowFraction)this.undertowFractionInstance.get();
            if (undertow.subresources().filterConfiguration() == null) {
                undertow.filterConfiguration();
            }
        } else {
            throw new RuntimeException("The microprofile-openapi fraction requires the undertow fraction!");
        }
        undertow.subresources().filterConfiguration().customFilter("wfs-openapi", customFilter -> {
            customFilter.module("org.wildfly.swarm.microprofile.openapi:runtime");
            customFilter.className("org.wildfly.swarm.microprofile.openapi.runtime.OpenApiHttpHandler");
        });
        undertow.subresources().server("default-server").subresources().host("default-host").filterRef("wfs-openapi", f -> f.priority(Integer.valueOf(100)));
    }
}

