/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.microprofile.openapi.api;

import org.eclipse.microprofile.openapi.OASFilter;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.eclipse.microprofile.openapi.models.Paths;
import org.eclipse.microprofile.openapi.models.info.Info;
import org.jboss.logging.Logger;
import org.wildfly.swarm.microprofile.openapi.api.OpenApiConfig;
import org.wildfly.swarm.microprofile.openapi.api.models.OpenAPIImpl;
import org.wildfly.swarm.microprofile.openapi.api.models.PathsImpl;
import org.wildfly.swarm.microprofile.openapi.api.models.info.InfoImpl;
import org.wildfly.swarm.microprofile.openapi.api.util.FilterUtil;
import org.wildfly.swarm.microprofile.openapi.api.util.MergeUtil;
import org.wildfly.swarm.microprofile.openapi.api.util.ServersUtil;

public class OpenApiDocument {
    public static final OpenApiDocument INSTANCE = new OpenApiDocument();
    private static final Logger LOGGER = Logger.getLogger(OpenApiDocument.class);
    private transient OpenApiConfig config;
    private transient OpenAPI annotationsModel;
    private transient OpenAPI readerModel;
    private transient OpenAPI staticFileModel;
    private transient OASFilter filter;
    private transient String archiveName;
    private transient OpenAPI model;

    private OpenApiDocument() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OpenAPI get() {
        OpenApiDocument openApiDocument = INSTANCE;
        synchronized (openApiDocument) {
            if (this.model == null) {
                throw new IllegalStateException("Model not initialized yet");
            }
            return this.model;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(OpenAPI model) {
        OpenApiDocument openApiDocument = INSTANCE;
        synchronized (openApiDocument) {
            this.model = model;
            LOGGER.info((Object)("OpenAPI document set: " + model));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        OpenApiDocument openApiDocument = INSTANCE;
        synchronized (openApiDocument) {
            this.model = null;
            this.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSet() {
        OpenApiDocument openApiDocument = INSTANCE;
        synchronized (openApiDocument) {
            return this.model != null;
        }
    }

    public synchronized void config(OpenApiConfig config) {
        this.set(() -> {
            this.config = config;
        });
    }

    public void modelFromAnnotations(OpenAPI model) {
        this.set(() -> {
            this.annotationsModel = model;
        });
    }

    public void modelFromReader(OpenAPI model) {
        this.set(() -> {
            this.readerModel = model;
        });
    }

    public void modelFromStaticFile(OpenAPI model) {
        this.set(() -> {
            this.staticFileModel = model;
        });
    }

    public void filter(OASFilter filter) {
        this.set(() -> {
            this.filter = filter;
        });
    }

    public void archiveName(String archiveName) {
        this.set(() -> {
            this.archiveName = archiveName;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize() {
        OpenApiDocument openApiDocument = INSTANCE;
        synchronized (openApiDocument) {
            if (this.model != null) {
                this.modelAlreadyInitialized();
            }
            if (this.config == null) {
                throw new IllegalStateException("OpenApiConfig must be set before init");
            }
            OpenAPI merged = this.readerModel;
            merged = MergeUtil.mergeObjects(merged, this.staticFileModel);
            merged = MergeUtil.mergeObjects(merged, this.annotationsModel);
            if ((merged = this.filterModel(merged)) == null) {
                merged = new OpenAPIImpl();
                merged.setOpenapi("3.0.1");
            }
            if (merged.getPaths() == null) {
                merged.setPaths((Paths)new PathsImpl());
            }
            if (merged.getInfo() == null) {
                merged.setInfo((Info)new InfoImpl());
            }
            if (merged.getInfo().getTitle() == null) {
                merged.getInfo().setTitle((this.archiveName == null ? "Generated" : this.archiveName) + " API");
            }
            if (merged.getInfo().getVersion() == null) {
                merged.getInfo().setVersion("1.0");
            }
            ServersUtil.configureServers(this.config, merged);
            this.model = merged;
            LOGGER.info((Object)("OpenAPI document initialized: " + this.model));
            this.clear();
        }
    }

    private OpenAPI filterModel(OpenAPI model) {
        if (model == null || this.filter == null) {
            return model;
        }
        LOGGER.info((Object)("Filtering OpenAPI model using: " + this.filter));
        return FilterUtil.applyFilter(this.filter, model);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void set(Runnable action) {
        OpenApiDocument openApiDocument = INSTANCE;
        synchronized (openApiDocument) {
            if (this.model != null) {
                this.modelAlreadyInitialized();
            }
            action.run();
        }
    }

    private void modelAlreadyInitialized() {
        throw new IllegalStateException("Model already initialized");
    }

    private void clear() {
        this.config = null;
        this.annotationsModel = null;
        this.readerModel = null;
        this.staticFileModel = null;
        this.filter = null;
        this.archiveName = null;
    }
}

