/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.microprofile.openapi.runtime.scanner;

import java.lang.reflect.Modifier;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import javax.validation.constraints.NotNull;
import org.eclipse.microprofile.openapi.models.media.Schema;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.ArrayType;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.ParameterizedType;
import org.jboss.jandex.PrimitiveType;
import org.jboss.jandex.Type;
import org.jboss.logging.Logger;
import org.wildfly.swarm.microprofile.openapi.api.models.media.SchemaImpl;
import org.wildfly.swarm.microprofile.openapi.runtime.scanner.CollectionStandin;
import org.wildfly.swarm.microprofile.openapi.runtime.scanner.MapStandin;
import org.wildfly.swarm.microprofile.openapi.runtime.scanner.TypeResolver;
import org.wildfly.swarm.microprofile.openapi.runtime.util.JandexUtil;
import org.wildfly.swarm.microprofile.openapi.runtime.util.SchemaFactory;
import org.wildfly.swarm.microprofile.openapi.runtime.util.TypeUtil;

public class OpenApiDataObjectScanner {
    private static final Logger LOG = Logger.getLogger(OpenApiDataObjectScanner.class);
    private static final Type OBJECT_TYPE = Type.create((DotName)DotName.createSimple((String)Object.class.getName()), (Type.Kind)Type.Kind.CLASS);
    private static final DotName COLLECTION_INTERFACE_NAME = DotName.createSimple((String)Collection.class.getName());
    private static final Type COLLECTION_TYPE = Type.create((DotName)COLLECTION_INTERFACE_NAME, (Type.Kind)Type.Kind.CLASS);
    private static final DotName MAP_INTERFACE_NAME = DotName.createSimple((String)Map.class.getName());
    private static final Type MAP_TYPE = Type.create((DotName)MAP_INTERFACE_NAME, (Type.Kind)Type.Kind.CLASS);
    private static final DotName ENUM_INTERFACE_NAME = DotName.createSimple((String)Enum.class.getName());
    private static final Type ENUM_TYPE = Type.create((DotName)ENUM_INTERFACE_NAME, (Type.Kind)Type.Kind.CLASS);
    private static final Type STRING_TYPE = Type.create((DotName)DotName.createSimple((String)String.class.getName()), (Type.Kind)Type.Kind.CLASS);
    private static final Type ARRAY_TYPE_OBJECT = ArrayType.create((DotName)DotName.createSimple((String)"[Ljava.lang.Object;"), (Type.Kind)Type.Kind.ARRAY);
    private final IndexView index;
    private final Type rootClassType;
    private final ClassInfo rootClassInfo;
    private Schema rootSchema;
    private final TypeUtil.TypeWithFormat classTypeFormat;
    private final Deque<PathEntry> path = new ArrayDeque<PathEntry>();

    public OpenApiDataObjectScanner(IndexView index, Type classType) {
        this.index = index;
        this.rootClassType = classType;
        this.classTypeFormat = TypeUtil.getTypeFormat(classType);
        this.rootSchema = new SchemaImpl();
        this.rootClassInfo = this.initialType(classType);
    }

    private boolean isSpecialType(Type type) {
        return this.isA(type, COLLECTION_TYPE) || this.isA(type, MAP_TYPE);
    }

    private ClassInfo initialType(Type type) {
        if (this.isA(type, COLLECTION_TYPE)) {
            return this.index.getClassByName(DotName.createSimple((String)CollectionStandin.class.getName()));
        }
        if (this.isA(type, MAP_TYPE)) {
            return this.index.getClassByName(DotName.createSimple((String)MapStandin.class.getName()));
        }
        return this.index.getClassByName(type.name());
    }

    public static Schema process(IndexView index, Type type) {
        return new OpenApiDataObjectScanner(index, type).process();
    }

    public static Schema process(PrimitiveType primitive) {
        TypeUtil.TypeWithFormat typeFormat = TypeUtil.getTypeFormat(primitive);
        SchemaImpl primitiveSchema = new SchemaImpl();
        primitiveSchema.setType(typeFormat.getSchemaType());
        primitiveSchema.setFormat(typeFormat.getFormat().format());
        return primitiveSchema;
    }

    public static Schema process(IndexView index, ParameterizedType pType) {
        return new OpenApiDataObjectScanner(index, (Type)pType).process();
    }

    public Schema process() {
        LOG.debugv("Starting processing with root: {0}", (Object)this.rootClassType.name());
        if (this.isTerminalType(this.rootClassType)) {
            SchemaImpl simpleSchema = new SchemaImpl();
            simpleSchema.setType(this.classTypeFormat.getSchemaType());
            simpleSchema.setFormat(this.classTypeFormat.getFormat().format());
            return simpleSchema;
        }
        if (this.rootClassInfo == null && this.path.size() == 0) {
            return null;
        }
        PathEntry root = PathEntry.rootNode(this.rootClassType, this.rootClassInfo, this.rootSchema);
        if (this.isSpecialType(this.rootClassType)) {
            this.resolveSpecial(root, this.rootClassType);
        } else {
            this.path.push(root);
        }
        this.dfs(this.path.peek());
        return this.rootSchema;
    }

    private void dfs(PathEntry rootNode) {
        PathEntry currentPathEntry = rootNode;
        while (!this.path.isEmpty()) {
            ClassInfo currentClass = currentPathEntry.clazz;
            Schema currentSchema = currentPathEntry.schema;
            Type currentType = currentPathEntry.clazzType;
            currentSchema = this.readKlass(currentClass, currentSchema);
            LOG.debugv("Getting all fields for: {0} in class: {1}", (Object)currentType, (Object)currentClass);
            Map<FieldInfo, TypeResolver> allFields = TypeResolver.getAllFields(this.index, currentType, currentClass);
            for (Map.Entry<FieldInfo, TypeResolver> entry : allFields.entrySet()) {
                FieldInfo field = entry.getKey();
                TypeResolver resolver = entry.getValue();
                if (Modifier.isStatic(field.flags())) continue;
                LOG.tracev("Iterating field {0}", (Object)field);
                this.processField(field, resolver, currentSchema, currentPathEntry);
            }
            currentPathEntry = this.path.pop();
        }
    }

    private Schema readKlass(ClassInfo currentClass, Schema currentSchema) {
        AnnotationInstance annotation = TypeUtil.getSchemaAnnotation(currentClass);
        if (annotation != null) {
            return SchemaFactory.readSchema(this.index, currentSchema, annotation, Collections.emptyMap());
        }
        return currentSchema;
    }

    private void resolveSpecial(PathEntry root, Type type) {
        Map<FieldInfo, TypeResolver> fieldResolution = TypeResolver.getAllFields(this.index, type, this.rootClassInfo);
        this.rootSchema = this.preProcessSpecial(type, fieldResolution.values().iterator().next(), this.rootSchema, root);
    }

    private Schema preProcessSpecial(Type type, TypeResolver typeResolver, Schema parentSchema, PathEntry currentPathEntry) {
        SchemaImpl fieldSchema = new SchemaImpl();
        AnnotationInstance schemaAnno = TypeUtil.getSchemaAnnotation(type);
        if (schemaAnno != null) {
            return this.readSchemaAnnotatedField(schemaAnno, type.name().toString(), type, typeResolver, parentSchema, fieldSchema, currentPathEntry);
        }
        this.readUnannotatedField(typeResolver, type, fieldSchema, currentPathEntry);
        return fieldSchema;
    }

    private Schema processField(FieldInfo field, TypeResolver typeResolver, Schema parentSchema, PathEntry currentPathEntry) {
        SchemaImpl fieldSchema = new SchemaImpl();
        parentSchema.addProperty(field.name(), (Schema)fieldSchema);
        AnnotationInstance schemaAnno = TypeUtil.getSchemaAnnotation(field);
        if (schemaAnno != null) {
            return this.readSchemaAnnotatedField(schemaAnno, field.name(), field.type(), typeResolver, parentSchema, fieldSchema, currentPathEntry);
        }
        this.readUnannotatedField(typeResolver, field.type(), fieldSchema, currentPathEntry);
        return fieldSchema;
    }

    private Schema readSchemaAnnotatedField(AnnotationInstance annotation, String name, Type type, TypeResolver typeResolver, Schema parent, Schema schema, PathEntry pathEntry) {
        if (annotation == null) {
            return parent;
        }
        LOG.debugv("Processing @Schema annotation {0} on a field {1}", (Object)annotation, (Object)name);
        Boolean isHidden = JandexUtil.booleanValue(annotation, "hidden");
        if (isHidden != null && isHidden == Boolean.TRUE) {
            return parent;
        }
        if (JandexUtil.booleanValueWithDefault(annotation, "required").booleanValue()) {
            parent.addRequired(name);
        }
        Type postProcessedField = this.processType(type, typeResolver, schema, pathEntry);
        TypeUtil.TypeWithFormat typeFormat = TypeUtil.getTypeFormat(postProcessedField);
        HashMap<String, Object> overrides = new HashMap<String, Object>();
        overrides.put("type", typeFormat.getSchemaType());
        overrides.put("format", typeFormat.getFormat().format());
        return SchemaFactory.readSchema(this.index, schema, annotation, overrides);
    }

    private Type processType(Type fieldType, TypeResolver typeResolver, Schema schema, PathEntry pathEntry) {
        if (this.isTerminalType(fieldType)) {
            return fieldType;
        }
        if (fieldType.kind() == Type.Kind.WILDCARD_TYPE) {
            fieldType = TypeUtil.resolveWildcard(fieldType.asWildcardType());
        }
        if (fieldType.kind() == Type.Kind.ARRAY) {
            LOG.debugv("Processing an array {0}", (Object)fieldType);
            ArrayType arrayType = fieldType.asArrayType();
            SchemaImpl arrSchema = new SchemaImpl();
            schema.type(Schema.SchemaType.ARRAY);
            schema.items((Schema)arrSchema);
            TypeUtil.TypeWithFormat typeFormat = TypeUtil.getTypeFormat(arrayType.component());
            arrSchema.setType(typeFormat.getSchemaType());
            arrSchema.setFormat(typeFormat.getFormat().format());
            if (!this.isTerminalType(arrayType.component()) && this.indexContains(fieldType)) {
                ClassInfo klazz = this.getClassByName(fieldType);
                this.pushPathPair(pathEntry, fieldType, klazz, arrSchema);
            }
            return arrayType;
        }
        if (this.isA(fieldType, ENUM_TYPE) && this.indexContains(fieldType)) {
            LOG.debugv("Processing an enum {0}", (Object)fieldType);
            ClassInfo enumKlazz = this.getClassByName(fieldType);
            for (FieldInfo enumField : enumKlazz.fields()) {
                if (enumField.name().endsWith("$VALUES") || !TypeUtil.getName(enumField.type()).equals((Object)enumKlazz.name())) continue;
                schema.addEnumeration((Object)enumField.name());
            }
            return STRING_TYPE;
        }
        if (fieldType.kind() == Type.Kind.PARAMETERIZED_TYPE) {
            return this.readParamType(pathEntry, schema, fieldType.asParameterizedType(), typeResolver);
        }
        if (fieldType.kind() == Type.Kind.TYPE_VARIABLE || fieldType.kind() == Type.Kind.UNRESOLVED_TYPE_VARIABLE) {
            return this.resolveTypeVariable(typeResolver, schema, pathEntry, fieldType);
        }
        if (this.isA(fieldType, COLLECTION_TYPE)) {
            return ARRAY_TYPE_OBJECT;
        }
        if (this.isA(fieldType, MAP_TYPE)) {
            return OBJECT_TYPE;
        }
        if (this.indexContains(fieldType)) {
            this.pushFieldToPath(pathEntry, fieldType, schema);
        } else {
            LOG.debugv("Encountered type not in Jandex index that is not well-known type. Will not traverse it: {0}", (Object)fieldType);
        }
        return fieldType;
    }

    private Type resolveTypeVariable(TypeResolver typeResolver, Schema schema, PathEntry pathEntry, Type fieldType) {
        Type resolvedType = typeResolver.getResolvedType(fieldType);
        LOG.debugv("Resolved type {0} -> {1}", (Object)fieldType, (Object)resolvedType);
        if (this.isTerminalType(resolvedType) || this.getClassByName(resolvedType) == null) {
            LOG.tracev("Is a terminal type {0}", (Object)resolvedType);
            TypeUtil.TypeWithFormat replacement = TypeUtil.getTypeFormat(resolvedType);
            schema.setType(replacement.getSchemaType());
            schema.setFormat(replacement.getFormat().format());
        } else {
            LOG.debugv("Attempting to do TYPE_VARIABLE substitution: {0} -> {1}", (Object)fieldType, (Object)resolvedType);
            if (this.indexContains(resolvedType)) {
                ClassInfo klazz = this.getClassByName(resolvedType);
                PathEntry entry = PathEntry.leafNode(pathEntry, klazz, resolvedType, schema);
                this.path.push(entry);
            } else {
                LOG.debugv("Class for type {0} not available", (Object)resolvedType);
            }
        }
        return resolvedType;
    }

    private void readUnannotatedField(TypeResolver typeResolver, Type type, Schema schema, PathEntry pathEntry) {
        if (!this.shouldInferUnannotatedFields()) {
            return;
        }
        LOG.debugv("Processing unannotated field {0}", (Object)type);
        Type processedType = this.processType(type, typeResolver, schema, pathEntry);
        TypeUtil.TypeWithFormat typeFormat = TypeUtil.getTypeFormat(processedType);
        schema.setType(typeFormat.getSchemaType());
        if (typeFormat.getFormat().hasFormat()) {
            schema.setFormat(typeFormat.getFormat().format());
        }
    }

    private Type readParamType(PathEntry pathEntry, Schema schema, ParameterizedType pType, TypeResolver typeResolver) {
        LOG.debugv("Processing parameterized type {0}", (Object)pType);
        if (this.isA((Type)pType, COLLECTION_TYPE)) {
            LOG.debugv("Processing Java Collection. Will treat as an array.", new Object[0]);
            SchemaImpl arraySchema = new SchemaImpl();
            schema.type(Schema.SchemaType.ARRAY);
            schema.items((Schema)arraySchema);
            Type arg = (Type)pType.arguments().get(0);
            if (this.isTerminalType(arg)) {
                TypeUtil.TypeWithFormat terminalType = TypeUtil.getTypeFormat(arg);
                arraySchema.type(terminalType.getSchemaType());
                arraySchema.format(terminalType.getFormat().format());
            } else if (arg.kind() == Type.Kind.TYPE_VARIABLE || arg.kind() == Type.Kind.UNRESOLVED_TYPE_VARIABLE || arg.kind() == Type.Kind.WILDCARD_TYPE) {
                Type resolved = this.resolveTypeVariable(typeResolver, arraySchema, pathEntry, arg);
                if (this.indexContains(resolved)) {
                    arraySchema.type(Schema.SchemaType.OBJECT);
                }
            } else if (this.indexContains(arg)) {
                arraySchema.type(Schema.SchemaType.OBJECT);
                this.pushFieldToPath(pathEntry, arg, arraySchema);
            }
            return ARRAY_TYPE_OBJECT;
        }
        if (this.isA((Type)pType, MAP_TYPE)) {
            LOG.debugv("Processing Map. Will treat as an object.", new Object[0]);
            schema.type(Schema.SchemaType.OBJECT);
            if (pType.arguments().size() == 2) {
                Type valueType = (Type)pType.arguments().get(1);
                SchemaImpl propsSchema = new SchemaImpl();
                if (this.isTerminalType(valueType)) {
                    TypeUtil.TypeWithFormat tf = TypeUtil.getTypeFormat(valueType);
                    propsSchema.setType(tf.getSchemaType());
                    propsSchema.setFormat(tf.getFormat().format());
                } else if (valueType.kind() == Type.Kind.TYPE_VARIABLE || valueType.kind() == Type.Kind.UNRESOLVED_TYPE_VARIABLE || valueType.kind() == Type.Kind.WILDCARD_TYPE) {
                    Type resolved = this.resolveTypeVariable(typeResolver, propsSchema, pathEntry, valueType);
                    if (this.indexContains(resolved)) {
                        propsSchema.type(Schema.SchemaType.OBJECT);
                    }
                } else if (this.indexContains(valueType)) {
                    propsSchema.type(Schema.SchemaType.OBJECT);
                    this.pushFieldToPath(pathEntry, valueType, propsSchema);
                }
                schema.additionalProperties((Schema)propsSchema);
            }
            return OBJECT_TYPE;
        }
        ClassInfo klazz = this.getClassByName((Type)pType);
        PathEntry pair = new PathEntry(pathEntry, klazz, (Type)pType, schema);
        this.path.push(pair);
        return pType;
    }

    private void pushFieldToPath(PathEntry parentPathEntry, Type type, Schema schema) {
        ClassInfo klazzInfo = this.getClassByName(type);
        this.pushPathPair(parentPathEntry, type, klazzInfo, schema);
    }

    private void pushPathPair(@NotNull PathEntry parentPathEntry, @NotNull Type type, @NotNull ClassInfo klazzInfo, @NotNull Schema schema) {
        PathEntry entry = PathEntry.leafNode(parentPathEntry, klazzInfo, type, schema);
        if (parentPathEntry.hasParent(entry)) {
            LOG.debugv("Possible cycle was detected at: {0}. Will not search further.", (Object)klazzInfo);
            LOG.tracev("Path: {0}", (Object)entry.toStringWithGraph());
            if (schema.getDescription() == null) {
                schema.description("Cyclic reference to " + klazzInfo.name());
            }
        } else {
            LOG.debugv("Adding child node to path: {0}", (Object)klazzInfo);
            this.path.push(entry);
        }
    }

    private ClassInfo getClassByName(@NotNull Type type) {
        return this.index.getClassByName(TypeUtil.getName(type));
    }

    private boolean indexContains(@NotNull Type type) {
        return this.getClassByName(type) != null;
    }

    private boolean isA(Type testSubject, Type test) {
        return TypeUtil.isA(this.index, testSubject, test);
    }

    private boolean isTerminalType(Type type) {
        if (type.kind() == Type.Kind.TYPE_VARIABLE || type.kind() == Type.Kind.WILDCARD_TYPE || type.kind() == Type.Kind.ARRAY) {
            return false;
        }
        if (type.kind() == Type.Kind.PRIMITIVE || type.kind() == Type.Kind.VOID) {
            return true;
        }
        TypeUtil.TypeWithFormat tf = TypeUtil.getTypeFormat(type);
        return tf.getSchemaType() != Schema.SchemaType.OBJECT && tf.getSchemaType() != Schema.SchemaType.ARRAY;
    }

    private boolean shouldInferUnannotatedFields() {
        String infer = System.getProperties().getProperty("openapi.infer-unannotated-types", "true");
        return Boolean.parseBoolean(infer);
    }

    private static final class PathEntry {
        private final PathEntry enclosing;
        private final Type clazzType;
        private final ClassInfo clazz;
        private final Schema schema;

        PathEntry(PathEntry enclosing, ClassInfo clazz, @NotNull Type clazzType, @NotNull Schema schema) {
            this.enclosing = enclosing;
            this.clazz = clazz;
            this.clazzType = clazzType;
            this.schema = schema;
        }

        static PathEntry rootNode(Type classType, ClassInfo classInfo, Schema rootSchema) {
            return new PathEntry(null, classInfo, classType, rootSchema);
        }

        static PathEntry leafNode(PathEntry parentNode, ClassInfo classInfo, Type classType, Schema rootSchema) {
            return new PathEntry(parentNode, classInfo, classType, rootSchema);
        }

        boolean hasParent(PathEntry candidate) {
            PathEntry test = this;
            while (test != null) {
                if (candidate.equals(test)) {
                    return true;
                }
                test = test.enclosing;
            }
            return false;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PathEntry pair = (PathEntry)o;
            return this.clazz != null ? this.clazz.equals(pair.clazz) : pair.clazz == null;
        }

        public int hashCode() {
            return this.clazz != null ? this.clazz.hashCode() : 0;
        }

        public String toString() {
            return "Pair{clazz=" + this.clazz + ", schema=" + this.schema + '}';
        }

        String toStringWithGraph() {
            return "Pair{clazz=" + this.clazz + ", schema=" + this.schema + ", parent=" + (this.enclosing != null ? this.enclosing.toStringWithGraph() : "<root>") + "}";
        }
    }
}

