/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.microprofile.openapi.api;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.microprofile.config.Config;

public class OpenApiConfig {
    private Config config;
    private String modelReader;
    private String filter;
    private Boolean scanDisable;
    private Set<String> scanPackages;
    private Set<String> scanClasses;
    private Set<String> scanExcludePackages;
    private Set<String> scanExcludeClasses;
    private Set<String> servers;
    private Boolean scanDependenciesDisable;
    private Set<String> scanDependenciesJars;

    public OpenApiConfig(Config config) {
        this.config = config;
    }

    protected Config getConfig() {
        return this.config;
    }

    public String modelReader() {
        if (this.modelReader == null) {
            this.modelReader = this.getConfig().getOptionalValue("mp.openapi.model.reader", String.class).orElse(null);
        }
        return this.modelReader;
    }

    public String filter() {
        if (this.filter == null) {
            this.filter = this.getConfig().getOptionalValue("mp.openapi.filter", String.class).orElse(null);
        }
        return this.filter;
    }

    public boolean scanDisable() {
        if (this.scanDisable == null) {
            this.scanDisable = this.getConfig().getOptionalValue("mp.openapi.scan.disable", Boolean.class).orElse(false);
        }
        return this.scanDisable;
    }

    public Set<String> scanPackages() {
        if (this.scanPackages == null) {
            String packages = this.getConfig().getOptionalValue("mp.openapi.scan.packages", String.class).orElse(null);
            this.scanPackages = OpenApiConfig.asCsvSet(packages);
        }
        return this.scanPackages;
    }

    public Set<String> scanClasses() {
        if (this.scanClasses == null) {
            String classes = this.getConfig().getOptionalValue("mp.openapi.scan.classes", String.class).orElse(null);
            this.scanClasses = OpenApiConfig.asCsvSet(classes);
        }
        return this.scanClasses;
    }

    public Set<String> scanExcludePackages() {
        if (this.scanExcludePackages == null) {
            String packages = this.getConfig().getOptionalValue("mp.openapi.scan.exclude.packages", String.class).orElse(null);
            this.scanExcludePackages = OpenApiConfig.asCsvSet(packages);
        }
        return this.scanExcludePackages;
    }

    public Set<String> scanExcludeClasses() {
        if (this.scanExcludeClasses == null) {
            String classes = this.getConfig().getOptionalValue("mp.openapi.scan.exclude.classes", String.class).orElse(null);
            this.scanExcludeClasses = OpenApiConfig.asCsvSet(classes);
        }
        return this.scanExcludeClasses;
    }

    public Set<String> servers() {
        if (this.servers == null) {
            String theServers = this.getConfig().getOptionalValue("mp.openapi.servers", String.class).orElse(null);
            this.servers = OpenApiConfig.asCsvSet(theServers);
        }
        return this.servers;
    }

    public Set<String> pathServers(String path) {
        String servers = this.getConfig().getOptionalValue("mp.openapi.servers.path." + path, String.class).orElse(null);
        return OpenApiConfig.asCsvSet(servers);
    }

    public Set<String> operationServers(String operationId) {
        String servers = this.getConfig().getOptionalValue("mp.openapi.servers.operation." + operationId, String.class).orElse(null);
        return OpenApiConfig.asCsvSet(servers);
    }

    public boolean scanDependenciesDisable() {
        if (this.scanDependenciesDisable == null) {
            this.scanDependenciesDisable = this.getConfig().getOptionalValue("mp.openapi.extensions.scan-dependencies.disable", Boolean.class).orElse(false);
        }
        return this.scanDependenciesDisable;
    }

    public Set<String> scanDependenciesJars() {
        if (this.scanDependenciesJars == null) {
            String classes = this.getConfig().getOptionalValue("mp.openapi.extensions.scan-dependencies.jars", String.class).orElse(null);
            this.scanDependenciesJars = OpenApiConfig.asCsvSet(classes);
        }
        return this.scanDependenciesJars;
    }

    private static Set<String> asCsvSet(String items) {
        HashSet<String> rval = new HashSet<String>();
        if (items != null) {
            String[] split;
            for (String item : split = items.split(",")) {
                rval.add(item.trim());
            }
        }
        return rval;
    }
}

