/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.microprofile.restclient;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Set;
import javax.ws.rs.client.ResponseProcessingException;
import javax.ws.rs.ext.ParamConverter;
import javax.ws.rs.ext.ParamConverterProvider;

class ProxyInvocationHandler
implements InvocationHandler {
    private Object target;
    private Set<Object> providerInstances;

    public ProxyInvocationHandler(Object target, Set<Object> providerInstances) {
        this.target = target;
        this.providerInstances = providerInstances;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        try {
            boolean replacementNeeded = false;
            Object[] argsReplacement = args != null ? new Object[args.length] : null;
            Annotation[][] parameterAnnotations = method.getParameterAnnotations();
            for (Object p : this.providerInstances) {
                if (!(p instanceof ParamConverterProvider)) continue;
                int index = 0;
                for (Object arg : args) {
                    block16: {
                        block15: {
                            Type[] genericTypes;
                            if (parameterAnnotations[index].length <= 0) break block15;
                            ParamConverter converter = ((ParamConverterProvider)p).getConverter(arg.getClass(), null, parameterAnnotations[index]);
                            if (converter == null || (genericTypes = this.getGenericTypes(converter.getClass())).length != 1) break block16;
                            switch (genericTypes[0].getTypeName()) {
                                case "java.lang.String": {
                                    ParamConverter stringConverter = converter;
                                    argsReplacement[index] = stringConverter.toString((Object)((String)arg));
                                    replacementNeeded = true;
                                    break block16;
                                }
                                case "java.lang.Integer": {
                                    ParamConverter intConverter = converter;
                                    argsReplacement[index] = intConverter.toString((Object)((Integer)arg));
                                    replacementNeeded = true;
                                    break block16;
                                }
                                case "java.lang.Boolean": {
                                    ParamConverter boolConverter = converter;
                                    argsReplacement[index] = boolConverter.toString((Object)((Boolean)arg));
                                    replacementNeeded = true;
                                    break block16;
                                }
                            }
                            continue;
                        }
                        argsReplacement[index] = arg;
                    }
                    ++index;
                }
            }
            return replacementNeeded ? method.invoke(this.target, argsReplacement) : method.invoke(this.target, args);
        }
        catch (InvocationTargetException e) {
            ResponseProcessingException rpe;
            Throwable cause;
            if (e.getCause() instanceof ResponseProcessingException && (cause = (rpe = (ResponseProcessingException)e.getCause()).getCause()) instanceof RuntimeException) {
                throw cause;
            }
            throw e;
        }
    }

    private Type[] getGenericTypes(Class aClass) {
        Type[] genericInterfaces = aClass.getGenericInterfaces();
        Type[] genericTypes = new Type[]{};
        for (Type genericInterface : genericInterfaces) {
            if (!(genericInterface instanceof ParameterizedType)) continue;
            genericTypes = ((ParameterizedType)genericInterface).getActualTypeArguments();
        }
        return genericTypes;
    }
}

