/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.microprofile.restclient.deployment;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.PassivationCapable;
import javax.enterprise.util.AnnotationLiteral;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.rest.client.RestClientBuilder;
import org.eclipse.microprofile.rest.client.inject.RestClient;

public class RestClientDelegateBean
implements Bean<Object>,
PassivationCapable {
    public static final String REST_URL_FORMAT = "%s/mp-rest/url";
    public static final String REST_SCOPE_FORMAT = "%s/mp-rest/scope";
    private final Class<?> proxyType;
    private final Class<? extends Annotation> scope;
    private final BeanManager beanManager;
    private final Config config;

    RestClientDelegateBean(Class<?> proxyType, BeanManager beanManager) {
        this.proxyType = proxyType;
        this.beanManager = beanManager;
        this.config = ConfigProvider.getConfig();
        this.scope = this.resolveScope();
    }

    public String getId() {
        return this.proxyType.getName();
    }

    public Class<?> getBeanClass() {
        return this.proxyType;
    }

    public Set<InjectionPoint> getInjectionPoints() {
        return Collections.emptySet();
    }

    public boolean isNullable() {
        return false;
    }

    public Object create(CreationalContext<Object> creationalContext) {
        RestClientBuilder builder = RestClientBuilder.newBuilder();
        String baseUrl = this.getBaseUrl();
        try {
            return builder.baseUrl(new URL(baseUrl)).build(this.proxyType);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("The value of URL was invalid " + baseUrl);
        }
    }

    public void destroy(Object instance, CreationalContext<Object> creationalContext) {
    }

    public Set<Type> getTypes() {
        return Collections.singleton(this.proxyType);
    }

    public Set<Annotation> getQualifiers() {
        HashSet<Annotation> qualifiers = new HashSet<Annotation>();
        qualifiers.add((Annotation)new AnnotationLiteral<Default>(){});
        qualifiers.add((Annotation)new AnnotationLiteral<Any>(){});
        qualifiers.add((Annotation)RestClient.LITERAL);
        return qualifiers;
    }

    public Class<? extends Annotation> getScope() {
        return this.scope;
    }

    public String getName() {
        return this.proxyType.getName();
    }

    public Set<Class<? extends Annotation>> getStereotypes() {
        return Collections.emptySet();
    }

    public boolean isAlternative() {
        return false;
    }

    private String getBaseUrl() {
        String property = String.format(REST_URL_FORMAT, this.proxyType.getName());
        return (String)this.config.getValue(property, String.class);
    }

    private Class<? extends Annotation> resolveScope() {
        Annotation[] annotations;
        String property = String.format(REST_SCOPE_FORMAT, this.proxyType.getName());
        String configuredScope = this.config.getOptionalValue(property, String.class).orElse(null);
        if (configuredScope != null) {
            try {
                return Class.forName(configuredScope);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Invalid scope: " + configuredScope, e);
            }
        }
        ArrayList<Annotation> possibleScopes = new ArrayList<Annotation>();
        for (Annotation annotation : annotations = this.proxyType.getDeclaredAnnotations()) {
            if (!this.beanManager.isScope(annotation.annotationType())) continue;
            possibleScopes.add(annotation);
        }
        if (possibleScopes.isEmpty()) {
            return Dependent.class;
        }
        if (possibleScopes.size() == 1) {
            return ((Annotation)possibleScopes.get(0)).annotationType();
        }
        throw new IllegalArgumentException("Ambiguous scope definition on " + this.proxyType + ": " + possibleScopes);
    }
}

