/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.mongodb.runtime;

import javax.enterprise.context.ApplicationScoped;
import org.wildfly.swarm.config.mongodb.Mongo;
import org.wildfly.swarm.container.util.DriverModuleBuilder;
import org.wildfly.swarm.container.util.Messages;
import org.wildfly.swarm.mongodb.MongoDBFraction;

@ApplicationScoped
public class MongoDBDriverInfo
extends DriverModuleBuilder {
    public MongoDBDriverInfo() {
        super("MongoDB", "com.mongodb.MongoClient", new String[]{"com.mongodb.MongoClientOptions", "com.mongodb.client.MongoDatabase", "com.mongodb.WriteConcern", "com.mongodb.ReadConcern", "com.mongodb.ReadConcernLevel"}, new String[]{"javax.api", "org.picketbox"});
    }

    public boolean detect(MongoDBFraction fraction) {
        if (0 == fraction.subresources().mongos().size()) {
            return false;
        }
        String moduleName = ((Mongo)fraction.subresources().mongos().get(0)).module() != null ? ((Mongo)fraction.subresources().mongos().get(0)).module() : "org.mongodb.driver";
        fraction.subresources().mongos().forEach(mongo -> {
            if (mongo.module() != null && !moduleName.equals(mongo.module())) {
                throw Messages.MESSAGES.cannotAddReferenceToModule(mongo.module(), moduleName);
            }
        });
        return super.detect(moduleName);
    }
}

