/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.monitor;

import java.util.Optional;
import org.jboss.dmr.ModelNode;
import org.wildfly.swarm.monitor.Status;

public class HealthStatus
implements Status {
    private Optional<ModelNode> message = Optional.empty();
    private final Status.State state;

    HealthStatus(Status.State state) {
        this.state = state;
    }

    public static HealthStatus up() {
        return new HealthStatus(Status.State.UP);
    }

    public static HealthStatus down() {
        return new HealthStatus(Status.State.DOWN);
    }

    public HealthStatus withAttribute(String key, String value) {
        ModelNode payload = this.getPayloadWrapper();
        payload.set(key, value);
        return this;
    }

    public HealthStatus withAttribute(String key, long value) {
        ModelNode payload = this.getPayloadWrapper();
        payload.set(key, value);
        return this;
    }

    public HealthStatus withAttribute(String key, boolean b) {
        ModelNode payload = this.getPayloadWrapper();
        payload.set(key, b);
        return this;
    }

    private ModelNode getPayloadWrapper() {
        if (!this.message.isPresent()) {
            this.message = Optional.of(new ModelNode());
        }
        return this.message.get();
    }

    @Override
    public Optional<String> getMessage() {
        return this.message.isPresent() ? Optional.of(this.getPayloadWrapper().toJSONString(false)) : Optional.empty();
    }

    @Override
    public Status.State getState() {
        return this.state;
    }
}

