/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.monitor.runtime;

import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import javax.naming.NamingException;
import org.wildfly.swarm.monitor.runtime.Monitor;

public class MonitorEndpoints
implements HttpHandler {
    private final Monitor monitor;

    public MonitorEndpoints(HttpHandler parent) {
        try {
            this.monitor = Monitor.lookup();
        }
        catch (NamingException e) {
            throw new RuntimeException("Failed to lookup monitor", e);
        }
    }

    public void handleRequest(HttpServerExchange exchange) throws Exception {
        if ("/node".equals(exchange.getRequestPath())) {
            this.nodeInfo(exchange);
        } else if ("/heap".equals(exchange.getRequestPath())) {
            this.heap(exchange);
        } else if ("/threads".equals(exchange.getRequestPath())) {
            this.threads(exchange);
        }
    }

    private void nodeInfo(HttpServerExchange exchange) {
        exchange.getResponseSender().send(this.monitor.getNodeInfo().toJSONString(false));
    }

    private void heap(HttpServerExchange exchange) {
        exchange.getResponseSender().send(this.monitor.heap().toJSONString(false));
    }

    private void threads(HttpServerExchange exchange) {
        exchange.getResponseSender().send(this.monitor.threads().toJSONString(false));
    }
}

