/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.monitor.runtime;

import io.undertow.attribute.ReadOnlyAttributeException;
import io.undertow.attribute.RelativePathAttribute;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import java.util.Arrays;
import java.util.List;
import javax.naming.NamingException;
import org.jboss.dmr.ModelNode;
import org.wildfly.swarm.monitor.runtime.HealthMetaData;
import org.wildfly.swarm.monitor.runtime.Monitor;
import org.wildfly.swarm.monitor.runtime.Queries;

class HttpContexts
implements HttpHandler {
    public static final String NODE = "/node";
    public static final String HEAP = "/heap";
    public static final String THREADS = "/threads";
    public static final String HEALTH = "/health";
    private final Monitor monitor;
    private final HttpHandler next;
    private RoundRobin roundRobin;

    public HttpContexts(HttpHandler next) {
        this.next = next;
        try {
            this.monitor = Monitor.lookup();
        }
        catch (NamingException e) {
            throw new RuntimeException("Failed to lookup monitor", e);
        }
    }

    public void handleRequest(HttpServerExchange exchange) throws Exception {
        if (NODE.equals(exchange.getRequestPath())) {
            this.nodeInfo(exchange);
        } else if (HEAP.equals(exchange.getRequestPath())) {
            this.heap(exchange);
        } else if (THREADS.equals(exchange.getRequestPath())) {
            this.threads(exchange);
        } else if (Queries.preventDirectAccess(this.monitor, exchange.getRelativePath())) {
            exchange.setStatusCode(403);
            exchange.endExchange();
        } else if (HEALTH.equals(exchange.getRequestPath())) {
            this.listHealtSubresources(exchange);
        } else if (exchange.getRelativePath().startsWith(HEALTH)) {
            this.healthRedirect(exchange);
        }
        this.next.handleRequest(exchange);
    }

    private void listHealtSubresources(HttpServerExchange exchange) {
        if (this.monitor.getHealthURIs().isEmpty()) {
            this.noHealthEndpoints(exchange);
        } else {
            ModelNode payload = new ModelNode();
            for (HealthMetaData endpoint : this.monitor.getHealthURIs()) {
                payload.get("links").add(HEALTH + endpoint.getWebContext());
            }
            exchange.setStatusCode(200);
            exchange.getResponseSender().send(payload.toJSONString(false));
        }
    }

    private void noHealthEndpoints(HttpServerExchange exchange) {
        exchange.setStatusCode(503);
        exchange.getResponseSender().send("No health endpoints configured!");
    }

    private void healthRedirect(HttpServerExchange exchange) {
        if (this.monitor.getHealthURIs().isEmpty()) {
            this.noHealthEndpoints(exchange);
        } else {
            String rel = exchange.getRelativePath();
            String subresource = rel.substring(HEALTH.length(), rel.length());
            boolean matches = false;
            for (HealthMetaData metaData : this.monitor.getHealthURIs()) {
                if (!metaData.getWebContext().equals(subresource)) continue;
                matches = true;
                break;
            }
            if (matches) {
                try {
                    RelativePathAttribute.INSTANCE.writeAttribute(exchange, subresource);
                }
                catch (ReadOnlyAttributeException e) {
                    e.printStackTrace();
                }
            } else {
                exchange.setStatusCode(404);
            }
        }
    }

    private void nodeInfo(HttpServerExchange exchange) {
        exchange.getResponseSender().send(this.monitor.getNodeInfo().toJSONString(false));
    }

    private void heap(HttpServerExchange exchange) {
        exchange.getResponseSender().send(this.monitor.heap().toJSONString(false));
    }

    private void threads(HttpServerExchange exchange) {
        exchange.getResponseSender().send(this.monitor.threads().toJSONString(false));
    }

    public static List<String> getDefaultContextNames() {
        List<String> contexts = Arrays.asList(NODE, HEAP, HEALTH, THREADS);
        return contexts;
    }

    class RoundRobin {
        private final List<HealthMetaData> contexts;
        private int pos = 0;

        public RoundRobin(List<HealthMetaData> contexts) {
            this.contexts = contexts;
        }

        String next() {
            if (this.pos >= this.contexts.size()) {
                this.pos = 0;
            }
            String next = this.contexts.get(this.pos).getWebContext();
            ++this.pos;
            return next;
        }
    }
}

