/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.monitor.runtime;

import java.util.ArrayList;
import java.util.List;
import javax.naming.NamingException;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Index;
import org.jboss.jandex.MethodInfo;
import org.jboss.msc.service.ServiceActivator;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ArchivePath;
import org.jboss.shrinkwrap.api.ArchivePaths;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.ClassAsset;
import org.jboss.shrinkwrap.impl.base.asset.AssetUtil;
import org.jboss.shrinkwrap.impl.base.path.BasicPath;
import org.wildfly.swarm.monitor.MonitorFraction;
import org.wildfly.swarm.monitor.runtime.HealthMetaData;
import org.wildfly.swarm.monitor.runtime.HealthResponseFilter;
import org.wildfly.swarm.monitor.runtime.Monitor;
import org.wildfly.swarm.monitor.runtime.MonitorServiceActivator;
import org.wildfly.swarm.spi.api.JARArchive;
import org.wildfly.swarm.spi.runtime.AbstractServerConfiguration;

public class MonitorConfiguration
extends AbstractServerConfiguration<MonitorFraction> {
    private static final ArchivePath PATH_WEB_INF = ArchivePaths.create((String)"WEB-INF");
    private static final ArchivePath PATH_CLASSES = ArchivePaths.create((ArchivePath)PATH_WEB_INF, (String)"classes");
    public static final DotName HEALTH = DotName.createSimple((String)"org.wildfly.swarm.monitor.Health");
    public static final DotName PATH = DotName.createSimple((String)"javax.ws.rs.Path");

    public MonitorConfiguration() {
        super(MonitorFraction.class);
    }

    public MonitorFraction defaultFraction() {
        return new MonitorFraction();
    }

    public List<ServiceActivator> getServiceActivators(MonitorFraction fraction) {
        ArrayList<ServiceActivator> activators = new ArrayList<ServiceActivator>();
        activators.add(new MonitorServiceActivator(fraction.securityRealm()));
        return activators;
    }

    public void prepareArchive(Archive<?> a) {
        JARArchive jarArchive = (JARArchive)a.as(JARArchive.class);
        jarArchive.addModule("javax.ws.rs.api");
        jarArchive.addModule("org.wildfly.swarm.monitor");
        jarArchive.addModule("org.jboss.dmr");
        ClassAsset resource = new ClassAsset(HealthResponseFilter.class);
        BasicPath location = new BasicPath(PATH_CLASSES, AssetUtil.getFullPathForClassResource(HealthResponseFilter.class));
        jarArchive.add((Asset)resource, (ArchivePath)location);
    }

    public void processArchiveMetaData(Archive<?> a, Index index) {
        List annotations = index.getAnnotations(PATH);
        for (AnnotationInstance annotation : annotations) {
            if (annotation.target().kind() != AnnotationTarget.Kind.CLASS) continue;
            ClassInfo classInfo = annotation.target().asClass();
            for (MethodInfo methodInfo : classInfo.methods()) {
                if (!methodInfo.hasAnnotation(HEALTH)) continue;
                StringBuffer sb = new StringBuffer();
                boolean isSecure = false;
                for (AnnotationInstance classAnnotation : classInfo.classAnnotations()) {
                    String methodPathValue;
                    if (!classAnnotation.name().equals((Object)PATH) || (methodPathValue = classAnnotation.value().asString()).equals("/")) continue;
                    sb.append(methodPathValue);
                }
                if (!methodInfo.hasAnnotation(PATH)) {
                    throw new RuntimeException("@Health requires an explicit @Path annotation");
                }
                sb.append(methodInfo.annotation(PATH).value().asString());
                AnnotationInstance healthAnnotation = methodInfo.annotation(HEALTH);
                isSecure = healthAnnotation.value("inheritSecurity") != null ? healthAnnotation.value("inheritSecurity").asBoolean() : true;
                try {
                    HealthMetaData metaData = new HealthMetaData(sb.toString(), isSecure);
                    Monitor.lookup().registerHealth(metaData);
                }
                catch (NamingException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

