/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.monitor.runtime;

import java.util.Iterator;
import org.wildfly.swarm.monitor.runtime.HealthMetaData;
import org.wildfly.swarm.monitor.runtime.Monitor;

class Queries {
    Queries() {
    }

    public static final boolean isSecuredHealthEndpoint(Monitor monitor, String relativePath) {
        return Queries.query(monitor, metaData -> relativePath.equals("/health" + metaData.getWebContext()) && metaData.isSecure());
    }

    public static final boolean preventDirectAccess(Monitor monitor, String relativePath) {
        return Queries.query(monitor, metaData -> relativePath.equals(metaData.getWebContext()) && metaData.isSecure());
    }

    public static final boolean query(Monitor monitor, Condition condition) {
        HealthMetaData metaData;
        boolean isCondition = false;
        Iterator<HealthMetaData> iterator = monitor.getHealthURIs().iterator();
        while (iterator.hasNext() && !(isCondition = condition.eval(metaData = iterator.next()))) {
        }
        return isCondition;
    }

    @FunctionalInterface
    public static interface Condition {
        public boolean eval(HealthMetaData var1);
    }
}

