/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.monitor.runtime;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.enterprise.inject.Vetoed;
import org.jboss.as.controller.ModelController;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.domain.management.SecurityRealm;
import org.jboss.as.server.ServerEnvironment;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.swarm.monitor.HealthMetaData;
import org.wildfly.swarm.monitor.runtime.Monitor;

@Vetoed
public class MonitorService
implements Monitor,
Service<MonitorService> {
    public static final ServiceName SERVICE_NAME = ServiceName.of((String[])new String[]{"swarm", "monitor"});
    private static final long DEFAULT_PROBE_TIMEOUT_SECONDS = 2L;
    private final InjectedValue<ServerEnvironment> serverEnvironmentValue = new InjectedValue();
    private final InjectedValue<ModelController> modelControllerValue = new InjectedValue();
    private final InjectedValue<SecurityRealm> securityRealmServiceValue = new InjectedValue();
    private final Optional<String> securityRealm;
    private ExecutorService executorService;
    private ServerEnvironment serverEnvironment;
    private ModelControllerClient controllerClient;
    private CopyOnWriteArrayList<HealthMetaData> endpoints = new CopyOnWriteArrayList();

    public MonitorService(Optional<String> securityRealm) {
        this.securityRealm = securityRealm;
    }

    @Override
    public long getProbeTimeoutSeconds() {
        return 2L;
    }

    public void start(StartContext startContext) throws StartException {
        this.executorService = Executors.newSingleThreadExecutor();
        this.serverEnvironment = (ServerEnvironment)this.serverEnvironmentValue.getValue();
        this.controllerClient = ((ModelController)this.modelControllerValue.getValue()).createClient((Executor)this.executorService);
        if (!this.securityRealm.isPresent()) {
            System.out.println("WARN: You are running the monitoring endpoints without any security realm configuration!");
        }
    }

    public void stop(StopContext stopContext) {
        if (this.executorService != null) {
            this.executorService.shutdownNow();
        }
    }

    public MonitorService getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    @Override
    public ModelNode getNodeInfo() {
        ModelNode payload = new ModelNode();
        ModelNode op = new ModelNode();
        op.get("address").setEmptyList();
        op.get("operation").set("query");
        op.get("select").add("name");
        op.get("select").add("server-state");
        op.get("select").add("suspend-state");
        op.get("select").add("running-mode");
        op.get("select").add("uuid");
        try {
            ModelNode response = this.controllerClient.execute(op);
            ModelNode unwrapped = MonitorService.unwrap(response);
            unwrapped.get("wfs-version").set("fixme");
            return unwrapped;
        }
        catch (IOException e) {
            return new ModelNode().get("failure-description").set(e.getMessage());
        }
    }

    @Override
    public ModelNode heap() {
        ModelNode op = new ModelNode();
        op.get("address").add("core-service", "platform-mbean");
        op.get("address").add("type", "memory");
        op.get("operation").set("query");
        op.get("select").add("heap-memory-usage");
        op.get("select").add("non-heap-memory-usage");
        try {
            ModelNode response = this.controllerClient.execute(op);
            return MonitorService.unwrap(response);
        }
        catch (IOException e) {
            return new ModelNode().get("failure-description").set(e.getMessage());
        }
    }

    @Override
    public ModelNode threads() {
        ModelNode op = new ModelNode();
        op.get("address").add("core-service", "platform-mbean");
        op.get("address").add("type", "threading");
        op.get("operation").set("query");
        op.get("select").add("thread-count");
        op.get("select").add("peak-thread-count");
        op.get("select").add("total-started-thread-count");
        op.get("select").add("current-thread-cpu-time");
        op.get("select").add("current-thread-user-time");
        try {
            ModelNode response = this.controllerClient.execute(op);
            return MonitorService.unwrap(response);
        }
        catch (IOException e) {
            return new ModelNode().get("failure-description").set(e.getMessage());
        }
    }

    @Override
    public void registerHealth(HealthMetaData metaData) {
        System.out.println("Adding /health endpoint delegate: " + metaData.getWebContext());
        this.endpoints.add(metaData);
    }

    @Override
    public List<HealthMetaData> getHealthURIs() {
        return Collections.unmodifiableList(this.endpoints);
    }

    @Override
    public Optional<SecurityRealm> getSecurityRealm() {
        if (this.securityRealm.isPresent() && null == this.securityRealmServiceValue.getOptionalValue()) {
            throw new RuntimeException("A security realm has been specified, but has not been configured: " + this.securityRealm.get());
        }
        return this.securityRealmServiceValue.getOptionalValue() != null ? Optional.of(this.securityRealmServiceValue.getValue()) : Optional.empty();
    }

    private static ModelNode unwrap(ModelNode response) {
        if (response.get("outcome").asString().equals("success")) {
            return response.get("result");
        }
        return response;
    }

    public Injector<ServerEnvironment> getServerEnvironmentInjector() {
        return this.serverEnvironmentValue;
    }

    public Injector<ModelController> getModelControllerInjector() {
        return this.modelControllerValue;
    }

    public Injector<SecurityRealm> getSecurityRealmInjector() {
        return this.securityRealmServiceValue;
    }
}

