/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.monitor.runtime;

import java.util.List;
import java.util.Optional;
import javax.inject.Singleton;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Index;
import org.jboss.jandex.MethodInfo;
import org.jboss.shrinkwrap.api.Archive;
import org.wildfly.swarm.monitor.HealthMetaData;
import org.wildfly.swarm.monitor.runtime.Monitor;
import org.wildfly.swarm.spi.api.ArchiveMetadataProcessor;
import org.wildfly.swarm.undertow.descriptors.JBossWebContainer;

@Singleton
public class HealthAnnotationProcessor
implements ArchiveMetadataProcessor {
    public static final DotName HEALTH = DotName.createSimple((String)"org.wildfly.swarm.monitor.Health");
    public static final DotName PATH = DotName.createSimple((String)"javax.ws.rs.Path");
    public static final DotName APP_PATH = DotName.createSimple((String)"javax.ws.rs.ApplicationPath");

    public void processArchive(Archive<?> archive, Index index) {
        JBossWebContainer war;
        Optional<Object> jbossWebContext = Optional.empty();
        if (archive instanceof JBossWebContainer && (war = (JBossWebContainer)archive).getContextRoot() != null) {
            jbossWebContext = Optional.of(war.getContextRoot());
        }
        Optional<Object> appPath = Optional.empty();
        List appPathAnnotations = index.getAnnotations(APP_PATH);
        for (AnnotationInstance annotation : appPathAnnotations) {
            if (annotation.target().kind() != AnnotationTarget.Kind.CLASS) continue;
            appPath = Optional.of(annotation.value().asString());
        }
        List pathAnnotations = index.getAnnotations(PATH);
        for (AnnotationInstance annotation : pathAnnotations) {
            if (annotation.target().kind() != AnnotationTarget.Kind.CLASS) continue;
            ClassInfo classInfo = annotation.target().asClass();
            for (MethodInfo methodInfo : classInfo.methods()) {
                if (!methodInfo.hasAnnotation(HEALTH)) continue;
                StringBuilder sb = new StringBuilder();
                boolean isSecure = false;
                if (jbossWebContext.isPresent() && !((String)jbossWebContext.get()).equals("/")) {
                    HealthAnnotationProcessor.safeAppend(sb, (String)jbossWebContext.get());
                }
                if (appPath.isPresent() && !((String)appPath.get()).equals("/")) {
                    HealthAnnotationProcessor.safeAppend(sb, (String)appPath.get());
                }
                for (AnnotationInstance classAnnotation : classInfo.classAnnotations()) {
                    String methodPathValue;
                    if (!classAnnotation.name().equals((Object)PATH) || (methodPathValue = classAnnotation.value().asString()).equals("/")) continue;
                    HealthAnnotationProcessor.safeAppend(sb, methodPathValue);
                }
                if (!methodInfo.hasAnnotation(PATH)) {
                    throw new RuntimeException("@Health requires an explicit @Path annotation");
                }
                sb.append(methodInfo.annotation(PATH).value().asString());
                AnnotationInstance healthAnnotation = methodInfo.annotation(HEALTH);
                isSecure = healthAnnotation.value("inheritSecurity") != null ? healthAnnotation.value("inheritSecurity").asBoolean() : true;
                try {
                    HealthMetaData metaData = new HealthMetaData(sb.toString(), isSecure);
                    Monitor.lookup().registerHealth(metaData);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static void safeAppend(StringBuilder sb, String pathToken) {
        if (!pathToken.startsWith("/")) {
            pathToken = "/" + pathToken;
        }
        if (pathToken.endsWith("/")) {
            pathToken = pathToken.substring(0, pathToken.length() - 1);
        }
        sb.append(pathToken);
    }
}

