/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.monitor.runtime;

import java.util.List;
import javax.inject.Singleton;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Index;
import org.jboss.jandex.MethodInfo;
import org.jboss.shrinkwrap.api.Archive;
import org.wildfly.swarm.monitor.HealthMetaData;
import org.wildfly.swarm.monitor.runtime.Monitor;
import org.wildfly.swarm.spi.api.ArchiveMetadataProcessor;

@Singleton
public class HealthAnnotationProcessor
implements ArchiveMetadataProcessor {
    public static final DotName HEALTH = DotName.createSimple((String)"org.wildfly.swarm.monitor.Health");
    public static final DotName PATH = DotName.createSimple((String)"javax.ws.rs.Path");

    public void processArchive(Archive<?> archive, Index index) {
        List annotations = index.getAnnotations(PATH);
        for (AnnotationInstance annotation : annotations) {
            if (annotation.target().kind() != AnnotationTarget.Kind.CLASS) continue;
            ClassInfo classInfo = annotation.target().asClass();
            for (MethodInfo methodInfo : classInfo.methods()) {
                if (!methodInfo.hasAnnotation(HEALTH)) continue;
                StringBuffer sb = new StringBuffer();
                boolean isSecure = false;
                for (AnnotationInstance classAnnotation : classInfo.classAnnotations()) {
                    String methodPathValue;
                    if (!classAnnotation.name().equals((Object)PATH) || (methodPathValue = classAnnotation.value().asString()).equals("/")) continue;
                    sb.append(methodPathValue);
                }
                if (!methodInfo.hasAnnotation(PATH)) {
                    throw new RuntimeException("@Health requires an explicit @Path annotation");
                }
                sb.append(methodInfo.annotation(PATH).value().asString());
                AnnotationInstance healthAnnotation = methodInfo.annotation(HEALTH);
                isSecure = healthAnnotation.value("inheritSecurity") != null ? healthAnnotation.value("inheritSecurity").asBoolean() : true;
                try {
                    HealthMetaData metaData = new HealthMetaData(sb.toString(), isSecure);
                    Monitor.lookup().registerHealth(metaData);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

