/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.monitor;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.jboss.dmr.ModelNode;
import org.wildfly.swarm.monitor.HealthStatus;
import org.wildfly.swarm.monitor.Status;

class CompositeHealthStatus
implements Status {
    private final Policy policy;
    private final List<HealthStatus> states;
    private static final Policy DEFAULT_POLICY = new Policy(){

        @Override
        public Status.State apply(List<HealthStatus> states) {
            boolean isDown = false;
            for (HealthStatus check : states) {
                if (Status.State.DOWN != check.getState()) continue;
                isDown = true;
                break;
            }
            return isDown ? Status.State.DOWN : Status.State.UP;
        }

        @Override
        public Optional<String> message(List<HealthStatus> states) {
            ModelNode payload = new ModelNode();
            for (HealthStatus state : states) {
                if (!state.getMessage().isPresent()) continue;
                payload.set(state.getMessage().get());
            }
            return payload.isDefined() ? Optional.of(payload.toJSONString(false)) : Optional.empty();
        }
    };

    CompositeHealthStatus(Policy policy) {
        this.policy = policy;
        this.states = new ArrayList<HealthStatus>();
    }

    CompositeHealthStatus() {
        this(DEFAULT_POLICY);
    }

    CompositeHealthStatus(List<HealthStatus> checks) {
        this();
        this.states.addAll(checks);
    }

    @Override
    public Status.State getState() {
        return this.policy.apply(this.states);
    }

    @Override
    public Optional<String> getMessage() {
        return this.policy.message(this.states);
    }

    public static CompositeHealthStatus build() {
        return new CompositeHealthStatus();
    }

    public static CompositeHealthStatus build(Policy policy) {
        return new CompositeHealthStatus(policy);
    }

    public static CompositeHealthStatus buildFrom(List<HealthStatus> checks) {
        return new CompositeHealthStatus(checks);
    }

    public static CompositeHealthStatus buildFrom(HealthStatus ... checks) {
        ArrayList<HealthStatus> list = new ArrayList<HealthStatus>(checks.length);
        for (HealthStatus check : checks) {
            list.add(check);
        }
        return new CompositeHealthStatus(list);
    }

    @Override
    public String toJson() {
        return null;
    }

    public static interface Policy {
        public Status.State apply(List<HealthStatus> var1);

        public Optional<String> message(List<HealthStatus> var1);
    }
}

