/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.monitor;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.wildfly.swarm.monitor.Status;

public class HealthStatus
implements Status {
    private static final String ID = "id";
    private static final String RESULT = "result";
    private static final String DATA = "data";
    private static final String ESCAPED_QUOTE = "\"";
    private final String name;
    private Optional<Map<String, Object>> message = Optional.empty();
    private Status.State state;

    HealthStatus(String name) {
        this.name = name;
    }

    public static HealthStatus named(String name) {
        return new HealthStatus(name);
    }

    public HealthStatus up() {
        this.assertNamed();
        this.state = Status.State.UP;
        return this;
    }

    private void assertNamed() {
        if (null == this.name) {
            throw new IllegalStateException("HealthStatus need to be named");
        }
    }

    public HealthStatus down() {
        this.state = Status.State.DOWN;
        return this;
    }

    public HealthStatus withAttribute(String key, String value) {
        Map<String, Object> payload = this.getPayloadWrapper();
        payload.put(key, value);
        return this;
    }

    public HealthStatus withAttribute(String key, long value) {
        Map<String, Object> payload = this.getPayloadWrapper();
        payload.put(key, value);
        return this;
    }

    public HealthStatus withAttribute(String key, boolean value) {
        Map<String, Object> payload = this.getPayloadWrapper();
        payload.put(key, value);
        return this;
    }

    private Map<String, Object> getPayloadWrapper() {
        if (!this.message.isPresent()) {
            this.message = Optional.of(new HashMap());
        }
        return this.message.get();
    }

    @Override
    public Optional<String> getMessage() {
        return this.message.isPresent() ? Optional.of(this.toJson()) : Optional.empty();
    }

    @Override
    public Status.State getState() {
        return this.state;
    }

    @Override
    public String toJson() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        sb.append(ESCAPED_QUOTE).append(ID).append("\":\"").append(this.name).append("\",");
        sb.append(ESCAPED_QUOTE).append(RESULT).append("\":\"").append(this.state.name()).append("\",");
        if (this.message.isPresent()) {
            sb.append(ESCAPED_QUOTE).append(DATA).append("\": {");
            Map<String, Object> atts = this.message.get();
            int i = 0;
            for (String key : atts.keySet()) {
                sb.append(ESCAPED_QUOTE).append(key).append("\":").append(this.encode(atts.get(key)));
                if (i < atts.keySet().size() - 1) {
                    sb.append(",");
                }
                ++i;
            }
            sb.append("}");
        }
        sb.append("}");
        return sb.toString();
    }

    private String encode(Object o) {
        String res = null;
        res = o instanceof String ? ESCAPED_QUOTE + o.toString() + ESCAPED_QUOTE : o.toString();
        return res;
    }
}

