/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.monitor.runtime;

import io.undertow.client.ClientCallback;
import io.undertow.client.ClientExchange;
import io.undertow.client.ClientResponse;
import io.undertow.server.Connectors;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.ServerConnection;
import io.undertow.server.protocol.http.HttpServerConnection;
import io.undertow.util.AttachmentKey;
import io.undertow.util.Headers;
import io.undertow.util.HttpString;
import io.undertow.util.Protocols;
import io.undertow.util.StringReadChannelListener;
import java.io.Closeable;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.enterprise.inject.Vetoed;
import javax.naming.NamingException;
import org.jboss.logging.Logger;
import org.wildfly.swarm.monitor.HealthMetaData;
import org.wildfly.swarm.monitor.runtime.InVMConnection;
import org.wildfly.swarm.monitor.runtime.Monitor;
import org.xnio.ChannelListeners;
import org.xnio.IoUtils;
import org.xnio.OptionMap;
import org.xnio.Options;
import org.xnio.Xnio;
import org.xnio.XnioWorker;

@Vetoed
class HttpContexts
implements HttpHandler {
    protected ThreadLocal<CountDownLatch> dispatched = new ThreadLocal();
    private AttachmentKey<List> RESPONSES = AttachmentKey.create(List.class);
    static AttachmentKey<String> TOKEN = AttachmentKey.create(String.class);
    private static final AttachmentKey<String> RESPONSE_BODY = AttachmentKey.create(String.class);
    private static Logger LOG = Logger.getLogger((String)"org.wildfly.swarm.monitor.health");
    public static final String NODE = "/node";
    public static final String HEAP = "/heap";
    public static final String THREADS = "/threads";
    public static final String HEALTH = "/health";
    static final String EPHEMERAL_TOKEN = UUID.randomUUID().toString();
    private final Monitor monitor;
    private final HttpHandler next;
    private XnioWorker worker;

    public HttpContexts(HttpHandler next) {
        try {
            this.worker = Xnio.getInstance().createWorker(OptionMap.builder().set(Options.WORKER_IO_THREADS, 5).set(Options.WORKER_TASK_CORE_THREADS, 5).set(Options.WORKER_TASK_MAX_THREADS, 10).set(Options.TCP_NODELAY, true).getMap());
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to create worker pool");
        }
        this.next = next;
        try {
            this.monitor = Monitor.lookup();
        }
        catch (NamingException e) {
            throw new RuntimeException("Failed to lookup monitor", e);
        }
    }

    public void handleRequest(HttpServerExchange exchange) throws Exception {
        if (this.dispatched.get() != null && this.dispatched.get().getCount() == 1L) {
            this.next.handleRequest(exchange);
            this.dispatched.set(null);
            return;
        }
        if (NODE.equals(exchange.getRequestPath())) {
            this.nodeInfo(exchange);
            return;
        }
        if (HEAP.equals(exchange.getRequestPath())) {
            this.heap(exchange);
            return;
        }
        if (THREADS.equals(exchange.getRequestPath())) {
            this.threads(exchange);
            return;
        }
        if (HEALTH.equals(exchange.getRequestPath())) {
            this.proxyRequests(exchange);
            return;
        }
        this.next.handleRequest(exchange);
    }

    private void proxyRequests(HttpServerExchange exchange) {
        if (this.monitor.getHealthURIs().isEmpty()) {
            this.noHealthEndpoints(exchange);
        } else {
            try {
                CopyOnWriteArrayList<InVMResponse> responses = new CopyOnWriteArrayList<InVMResponse>();
                CountDownLatch latch = new CountDownLatch(this.monitor.getHealthURIs().size());
                this.dispatched.set(latch);
                for (HealthMetaData healthCheck : this.monitor.getHealthURIs()) {
                    this.invokeHealthInVM(exchange, healthCheck, responses, latch);
                }
                latch.await(10L, TimeUnit.SECONDS);
                if (latch.getCount() > 0L) {
                    throw new Exception("Probe timed out");
                }
                boolean failed = false;
                if (!responses.isEmpty()) {
                    if (responses.size() != this.monitor.getHealthURIs().size()) {
                        throw new RuntimeException("The number of responses does not match!");
                    }
                    StringBuffer sb = new StringBuffer("{");
                    sb.append("\"checks\": [\n");
                    int i = 0;
                    for (InVMResponse resp : responses) {
                        if (200 == resp.getStatus()) {
                            sb.append(resp.getPayload());
                        } else if (503 == resp.getStatus()) {
                            sb.append(resp.getPayload());
                            failed = true;
                        } else {
                            throw new RuntimeException("Unexpected status code: " + resp.getStatus());
                        }
                        if (i < responses.size() - 1) {
                            sb.append(",\n");
                        }
                        ++i;
                    }
                    sb.append("],\n");
                    String outcome = failed ? "DOWN" : "UP";
                    sb.append("\"outcome\": \"" + outcome + "\"\n");
                    sb.append("}\n");
                    if (failed) {
                        exchange.setStatusCode(503);
                    }
                    exchange.getResponseSender().send(sb.toString());
                } else {
                    new RuntimeException("Responses should not be empty").printStackTrace();
                    exchange.setStatusCode(500);
                }
                exchange.endExchange();
            }
            catch (Throwable t) {
                LOG.error((Object)"Health check failed", t);
                if (!exchange.isResponseStarted()) {
                    exchange.setStatusCode(500);
                }
                exchange.endExchange();
            }
        }
    }

    private void invokeHealthInVM(HttpServerExchange exchange, HealthMetaData healthCheck, final List<InVMResponse> responses, final CountDownLatch latch) {
        try {
            String delegateContext = healthCheck.getWebContext();
            InVMConnection connection = new InVMConnection(this.worker);
            final HttpServerExchange mockExchange = new HttpServerExchange((ServerConnection)connection);
            mockExchange.setRequestScheme("http");
            mockExchange.setRequestMethod(new HttpString("GET"));
            mockExchange.setProtocol(Protocols.HTTP_1_0);
            mockExchange.setRequestURI(delegateContext);
            mockExchange.setRequestPath(delegateContext);
            mockExchange.setRelativePath(delegateContext);
            mockExchange.getRequestHeaders().add(Headers.HOST, exchange.getRequestHeaders().get(Headers.HOST).getFirst());
            mockExchange.putAttachment(TOKEN, (Object)EPHEMERAL_TOKEN);
            mockExchange.putAttachment(this.RESPONSES, responses);
            connection.addCloseListener(new ServerConnection.CloseListener(){

                public void closed(ServerConnection connection) {
                    LOG.trace((Object)"Mock connection closed");
                    StringBuffer sb = new StringBuffer();
                    ((InVMConnection)connection).flushTo(sb);
                    LOG.trace((Object)("Response payload: " + sb.toString()));
                    responses.add(new InVMResponse(mockExchange.getStatusCode(), sb.toString()));
                    mockExchange.removeAttachment(HttpContexts.this.RESPONSES);
                    IoUtils.safeClose((Closeable)connection);
                    latch.countDown();
                }
            });
            HttpServerConnection httpConnection = (HttpServerConnection)exchange.getConnection();
            mockExchange.startBlocking();
            Connectors.executeRootHandler((HttpHandler)httpConnection.getRootHandler(), (HttpServerExchange)mockExchange);
        }
        catch (Throwable t) {
            LOG.error((Object)"Health check failed", t);
            latch.countDown();
        }
    }

    private ClientCallback<ClientExchange> createClientCallback(final List<ClientResponse> responses, final CountDownLatch latch) {
        return new ClientCallback<ClientExchange>(){

            public void completed(ClientExchange result) {
                result.setResponseListener((ClientCallback)new ClientCallback<ClientExchange>(){

                    public void completed(final ClientExchange result) {
                        responses.add(result.getResponse());
                        new StringReadChannelListener(result.getConnection().getBufferPool()){

                            protected void stringDone(String string) {
                                result.getResponse().putAttachment(RESPONSE_BODY, (Object)string);
                                latch.countDown();
                            }

                            protected void error(IOException e) {
                                LOG.error((Object)"Failed to read response", (Throwable)e);
                                latch.countDown();
                            }
                        }.setup(result.getResponseChannel());
                    }

                    public void failed(IOException e) {
                        LOG.error((Object)"Failed to read response", (Throwable)e);
                        latch.countDown();
                    }
                });
                try {
                    result.getRequestChannel().shutdownWrites();
                    if (!result.getRequestChannel().flush()) {
                        result.getRequestChannel().getWriteSetter().set(ChannelListeners.flushingChannelListener(null, null));
                        result.getRequestChannel().resumeWrites();
                    }
                }
                catch (IOException e) {
                    LOG.error((Object)"Failed to read response", (Throwable)e);
                    latch.countDown();
                }
            }

            public void failed(IOException e) {
                LOG.error((Object)"Probe invocation failed", (Throwable)e);
                latch.countDown();
            }
        };
    }

    private void noHealthEndpoints(HttpServerExchange exchange) {
        exchange.setStatusCode(204);
        exchange.setReasonPhrase("No health endpoints configured!");
    }

    private void nodeInfo(HttpServerExchange exchange) {
        exchange.getResponseSender().send(this.monitor.getNodeInfo().toJSONString(false));
    }

    private void heap(HttpServerExchange exchange) {
        exchange.getResponseSender().send(this.monitor.heap().toJSONString(false));
    }

    private void threads(HttpServerExchange exchange) {
        exchange.getResponseSender().send(this.monitor.threads().toJSONString(false));
    }

    public static List<String> getDefaultContextNames() {
        return Arrays.asList(NODE, HEAP, HEALTH, THREADS);
    }

    class InVMResponse {
        private int status;
        private String payload;

        public InVMResponse(int status, String payload) {
            this.status = status;
            this.payload = payload;
        }

        public int getStatus() {
            return this.status;
        }

        public String getPayload() {
            return this.payload;
        }
    }
}

