/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.monitor.runtime;

import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.wildfly.swarm.spi.api.Customizer;
import org.wildfly.swarm.spi.runtime.annotations.Post;
import org.wildfly.swarm.undertow.UndertowFraction;

@Post
@ApplicationScoped
public class UndertowFilterCustomizer
implements Customizer {
    @Inject
    Instance<UndertowFraction> undertowFractionInstance;

    public void customize() {
        if (this.undertowFractionInstance.isUnsatisfied()) {
            throw new RuntimeException("The monitor fraction requires the undertow fraction!");
        }
        UndertowFraction undertow = (UndertowFraction)this.undertowFractionInstance.get();
        undertow.filterConfiguration();
        undertow.subresources().filterConfiguration().customFilter("wfs-monitor", customFilter -> {
            customFilter.module("org.wildfly.swarm.monitor:runtime");
            customFilter.className("org.wildfly.swarm.monitor.runtime.SecureHttpContexts");
        });
        undertow.subresources().server("default-server").subresources().host("default-host").filterRef("wfs-monitor", f -> f.priority(Integer.valueOf(100)));
    }
}

