/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.monitor.runtime;

import java.util.Collection;
import java.util.Optional;
import javax.inject.Inject;
import javax.naming.NamingException;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.shrinkwrap.api.Archive;
import org.wildfly.swarm.monitor.HealthMetaData;
import org.wildfly.swarm.monitor.runtime.Monitor;
import org.wildfly.swarm.spi.api.DeploymentProcessor;
import org.wildfly.swarm.spi.runtime.annotations.DeploymentScoped;
import org.wildfly.swarm.undertow.WARArchive;
import org.wildfly.swarm.undertow.descriptors.JBossWebContainer;

@DeploymentScoped
public class HealthAnnotationProcessor
implements DeploymentProcessor {
    public static final DotName HEALTH = DotName.createSimple((String)"org.wildfly.swarm.health.Health");
    public static final DotName PATH = DotName.createSimple((String)"javax.ws.rs.Path");
    public static final DotName APP_PATH = DotName.createSimple((String)"javax.ws.rs.ApplicationPath");
    private final Archive<?> archive;
    private final IndexView index;

    @Inject
    public HealthAnnotationProcessor(Archive archive, IndexView index) {
        this.archive = archive;
        this.index = index;
    }

    public void process() throws NamingException {
        JBossWebContainer war;
        Optional<Object> jbossWebContext = Optional.empty();
        if (this.archive.getName().endsWith(".war") && (war = (JBossWebContainer)this.archive.as(WARArchive.class)).getContextRoot() != null) {
            jbossWebContext = Optional.of(war.getContextRoot());
        }
        Optional<Object> appPath = Optional.empty();
        Collection appPathAnnotations = this.index.getAnnotations(APP_PATH);
        for (AnnotationInstance annotation : appPathAnnotations) {
            if (annotation.target().kind() != AnnotationTarget.Kind.CLASS) continue;
            appPath = Optional.of(annotation.value().asString());
        }
        Collection pathAnnotations = this.index.getAnnotations(PATH);
        for (AnnotationInstance annotation : pathAnnotations) {
            if (annotation.target().kind() != AnnotationTarget.Kind.CLASS) continue;
            ClassInfo classInfo = annotation.target().asClass();
            for (MethodInfo methodInfo : classInfo.methods()) {
                if (!methodInfo.hasAnnotation(HEALTH)) continue;
                StringBuilder sb = new StringBuilder();
                boolean isSecure = false;
                if (jbossWebContext.isPresent() && !((String)jbossWebContext.get()).equals("/")) {
                    HealthAnnotationProcessor.safeAppend(sb, (String)jbossWebContext.get());
                }
                if (appPath.isPresent() && !((String)appPath.get()).equals("/")) {
                    HealthAnnotationProcessor.safeAppend(sb, (String)appPath.get());
                }
                for (AnnotationInstance classAnnotation : classInfo.classAnnotations()) {
                    String methodPathValue;
                    if (!classAnnotation.name().equals((Object)PATH) || (methodPathValue = classAnnotation.value().asString()).equals("/")) continue;
                    HealthAnnotationProcessor.safeAppend(sb, methodPathValue);
                }
                if (!methodInfo.hasAnnotation(PATH)) {
                    throw new RuntimeException("@Health requires an explicit @Path annotation");
                }
                HealthAnnotationProcessor.safeAppend(sb, methodInfo.annotation(PATH).value().asString());
                AnnotationInstance healthAnnotation = methodInfo.annotation(HEALTH);
                isSecure = healthAnnotation.value("inheritSecurity") != null ? healthAnnotation.value("inheritSecurity").asBoolean() : true;
                HealthMetaData metaData = new HealthMetaData(sb.toString(), isSecure);
                Monitor.lookup().registerHealth(metaData);
            }
        }
    }

    public static void safeAppend(StringBuilder sb, String pathToken) {
        if (!pathToken.startsWith("/")) {
            pathToken = "/" + pathToken;
        }
        if (pathToken.endsWith("/")) {
            pathToken = pathToken.substring(0, pathToken.length() - 1);
        }
        sb.append(pathToken);
    }
}

