/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.monitor.runtime;

import io.undertow.security.api.AuthenticationMechanism;
import io.undertow.security.api.AuthenticationMode;
import io.undertow.security.api.NonceManager;
import io.undertow.security.handlers.AuthenticationCallHandler;
import io.undertow.security.handlers.AuthenticationConstraintHandler;
import io.undertow.security.handlers.AuthenticationMechanismsHandler;
import io.undertow.security.handlers.SecurityInitialHandler;
import io.undertow.security.idm.DigestAlgorithm;
import io.undertow.security.idm.IdentityManager;
import io.undertow.security.impl.BasicAuthenticationMechanism;
import io.undertow.security.impl.CachedAuthenticatedSessionMechanism;
import io.undertow.security.impl.DigestAuthenticationMechanism;
import io.undertow.security.impl.DigestQop;
import io.undertow.security.impl.SimpleNonceManager;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.PredicateHandler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.enterprise.inject.Vetoed;
import javax.naming.NamingException;
import org.jboss.as.domain.http.server.security.AuthenticationMechanismWrapper;
import org.jboss.as.domain.http.server.security.RealmIdentityManager;
import org.jboss.as.domain.management.AuthMechanism;
import org.jboss.as.domain.management.SecurityRealm;
import org.wildfly.swarm.monitor.runtime.HttpContexts;
import org.wildfly.swarm.monitor.runtime.Monitor;
import org.wildfly.swarm.monitor.runtime.Queries;

@Vetoed
public class SecureHttpContexts
implements HttpHandler {
    private final HttpHandler delegate;
    private final Monitor monitor;
    private final HttpHandler next;

    public SecureHttpContexts(HttpHandler next) {
        this.next = next;
        try {
            this.monitor = Monitor.lookup();
        }
        catch (NamingException e) {
            throw new RuntimeException("Failed to lookup monitor", e);
        }
        Optional<SecurityRealm> securityRealm = this.monitor.getSecurityRealm();
        this.delegate = securityRealm.isPresent() ? this.secureHandler(new HttpContexts(next), securityRealm.get()) : new HttpContexts(next);
    }

    public void handleRequest(HttpServerExchange exchange) throws Exception {
        this.delegate.handleRequest(exchange);
    }

    private HttpHandler secureHandler(HttpHandler toWrap, SecurityRealm securityRealm) {
        HttpHandler handler = toWrap;
        handler = new AuthenticationCallHandler(handler);
        handler = new AuthenticationConstraintHandler(handler);
        RealmIdentityManager idm = new RealmIdentityManager(securityRealm);
        Set mechanisms = securityRealm.getSupportedAuthenticationMechanisms();
        ArrayList<AuthenticationMechanism> undertowMechanisms = new ArrayList<AuthenticationMechanism>(mechanisms.size());
        undertowMechanisms.add(SecureHttpContexts.wrap((AuthenticationMechanism)new CachedAuthenticatedSessionMechanism(), null));
        for (AuthMechanism current : mechanisms) {
            switch (current) {
                case DIGEST: {
                    List<DigestAlgorithm> digestAlgorithms = Collections.singletonList(DigestAlgorithm.MD5);
                    List<DigestQop> digestQops = Collections.singletonList(DigestQop.AUTH);
                    undertowMechanisms.add(SecureHttpContexts.wrap((AuthenticationMechanism)new DigestAuthenticationMechanism(digestAlgorithms, digestQops, securityRealm.getName(), "Monitor", (NonceManager)new SimpleNonceManager()), current));
                    break;
                }
                case PLAIN: {
                    undertowMechanisms.add(SecureHttpContexts.wrap((AuthenticationMechanism)new BasicAuthenticationMechanism(securityRealm.getName()), current));
                    break;
                }
                case LOCAL: {
                    break;
                }
            }
        }
        handler = new AuthenticationMechanismsHandler(handler, undertowMechanisms);
        handler = new SecurityInitialHandler(AuthenticationMode.PRO_ACTIVE, (IdentityManager)idm, handler);
        handler = new PredicateHandler(exchange -> {
            if (!this.monitor.getSecurityRealm().isPresent()) {
                return false;
            }
            if (Queries.isAggregatorEndpoint(this.monitor, exchange.getRelativePath())) {
                return true;
            }
            if (Queries.isDirectAccessToHealthEndpoint(this.monitor, exchange.getRelativePath())) {
                return !this.hasTokenAuth(exchange);
            }
            return HttpContexts.getDefaultContextNames().contains(exchange.getRelativePath());
        }, handler, toWrap);
        return handler;
    }

    private boolean hasTokenAuth(HttpServerExchange exchange) {
        String token = (String)exchange.getAttachment(HttpContexts.TOKEN);
        return token != null && HttpContexts.EPHEMERAL_TOKEN.equals(token);
    }

    private static AuthenticationMechanism wrap(AuthenticationMechanism toWrap, AuthMechanism mechanism) {
        return new AuthenticationMechanismWrapper(toWrap, mechanism);
    }
}

