/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.msc.internal;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import org.jboss.msc.service.ServiceActivator;
import org.jboss.shrinkwrap.api.asset.Asset;

public class ServiceActivatorAsset
implements Asset {
    private List<String> activators = new ArrayList<String>();

    public ServiceActivatorAsset() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceActivatorAsset(InputStream inputStream) {
        BufferedReader in = new BufferedReader(new InputStreamReader(inputStream));
        try {
            String line;
            while ((line = in.readLine()) != null) {
                this.addServiceActivator(line);
            }
        }
        catch (IOException e) {
            System.err.println("ERROR reading ServiceActivatorAsset" + e);
            e.printStackTrace();
        }
        finally {
            try {
                in.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void addServiceActivator(String className) {
        this.activators.add(className);
    }

    public void addServiceActivator(Class<? extends ServiceActivator> cls) {
        this.activators.add(cls.getName());
    }

    public boolean containsServiceActivator(String className) {
        return this.activators.contains(className);
    }

    public InputStream openStream() {
        StringBuilder builder = new StringBuilder();
        for (String activator : this.activators) {
            builder.append(activator).append("\n");
        }
        return new ByteArrayInputStream(builder.toString().getBytes());
    }

    public String toString() {
        return this.activators.toString();
    }
}

