/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.msc;

import org.jboss.msc.service.ServiceActivator;
import org.jboss.shrinkwrap.api.Node;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.impl.base.ArchiveBase;
import org.jboss.shrinkwrap.impl.base.AssignableBase;
import org.wildfly.swarm.msc.ServiceActivatorArchive;
import org.wildfly.swarm.msc.ServiceActivatorAsset;

public class ServiceActivatorArchiveImpl
extends AssignableBase<ArchiveBase<?>>
implements ServiceActivatorArchive {
    private ServiceActivatorAsset asset;

    public ServiceActivatorArchiveImpl(ArchiveBase<?> archive) {
        super(archive);
        if (((ArchiveBase)this.getArchive()).getName().endsWith(".war")) {
            Node node = ((ArchiveBase)this.getArchive()).get("WEB-INF/classes/META-INF/services/" + ServiceActivator.class.getName());
            if (node != null) {
                Asset maybeCorrect = node.getAsset();
                this.asset = maybeCorrect instanceof ServiceActivatorAsset ? (ServiceActivatorAsset)maybeCorrect : new ServiceActivatorAsset(maybeCorrect.openStream());
            } else {
                this.asset = new ServiceActivatorAsset();
                ((ArchiveBase)this.getArchive()).add((Asset)this.asset, "WEB-INF/classes/META-INF/services/" + ServiceActivator.class.getName());
            }
        } else if (((ArchiveBase)this.getArchive()).getName().endsWith(".jar")) {
            Node node = ((ArchiveBase)this.getArchive()).get("META-INF/services/" + ServiceActivator.class.getName());
            if (node != null) {
                this.asset = (ServiceActivatorAsset)node.getAsset();
            } else {
                this.asset = new ServiceActivatorAsset();
                ((ArchiveBase)this.getArchive()).add((Asset)this.asset, "META-INF/services/" + ServiceActivator.class.getName());
            }
        }
    }

    @Override
    public ServiceActivatorArchive addServiceActivator(Class<? extends ServiceActivator> cls) {
        if (((ArchiveBase)this.getArchive()).getName().endsWith(".war")) {
            ((WebArchive)((ArchiveBase)this.getArchive()).as(WebArchive.class)).addClass(cls);
        } else if (((ArchiveBase)this.getArchive()).getName().endsWith(".jar")) {
            ((JavaArchive)((ArchiveBase)this.getArchive()).as(JavaArchive.class)).addClass(cls);
        }
        this.asset.addServiceActivator(cls);
        return this;
    }

    @Override
    public ServiceActivatorArchive addServiceActivator(String className) {
        this.asset.addServiceActivator(className);
        return this;
    }

    @Override
    public boolean containsServiceActivator(String className) {
        return this.asset.containsServiceActivator(className);
    }
}

