/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.database.mysql.runtime;

import javax.enterprise.inject.Any;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.wildfly.swarm.datasources.DatasourcesFraction;
import org.wildfly.swarm.spi.api.Customizer;
import org.wildfly.swarm.spi.runtime.annotations.Pre;

@Singleton
@Pre
public class MySQLDatasourceCustomizer
implements Customizer {
    @Inject
    @Any
    Instance<DatasourcesFraction> datasourcesFractionInstance;

    public void customize() {
        if (!this.datasourcesFractionInstance.isUnsatisfied()) {
            String dsName = System.getProperty("swarm.ds.name", "ExampleDS");
            String driverName = System.getProperty("swarm.jdbc.driver", "mysql");
            ((DatasourcesFraction)this.datasourcesFractionInstance.get()).jdbcDriver(driverName, d -> {
                d.driverClassName("com.mysql.jdbc.Driver");
                d.xaDatasourceClass("com.mysql.jdbc.jdbc2.optional.MysqlXADataSource");
                d.driverModuleName("com.mysql");
            }).dataSource(dsName, ds -> {
                ds.driverName(driverName);
                ds.connectionUrl(System.getProperty("swarm.ds.connection.url", "jdbc:mysql://localhost:3306/test"));
                ds.userName(System.getProperty("swarm.ds.username", "root"));
                ds.password(System.getProperty("swarm.ds.password", "root"));
            });
        }
    }
}

