/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.opentracing.hawkular.jaxrs;

import io.opentracing.Tracer;
import io.opentracing.contrib.global.GlobalTracer;
import io.opentracing.contrib.jaxrs2.server.ServerTracingDynamicFeature;
import org.hawkular.apm.api.services.TracePublisher;
import org.hawkular.apm.client.api.recorder.BatchTraceRecorder;
import org.hawkular.apm.client.api.recorder.LoggingRecorder;
import org.hawkular.apm.client.api.recorder.TraceRecorder;
import org.hawkular.apm.client.api.sampler.PercentageSampler;
import org.hawkular.apm.client.opentracing.APMTracer;
import org.hawkular.apm.client.opentracing.DeploymentMetaData;
import org.hawkular.apm.trace.publisher.rest.client.TracePublisherRESTClient;
import org.wildfly.swarm.spi.api.Fraction;
import org.wildfly.swarm.spi.api.annotations.DeploymentModule;
import org.wildfly.swarm.spi.api.annotations.DeploymentModules;

@DeploymentModules(value={@DeploymentModule(name="io.opentracing.hawkular"), @DeploymentModule(name="org.wildfly.swarm.opentracing.hawkular.jaxrs", slot="main")})
public class OpenTracingHawkularFraction
implements Fraction<OpenTracingHawkularFraction> {
    private APMJaxRsTracingBuilder apmJaxRsTracingBuilder = new APMJaxRsTracingBuilder();

    public OpenTracingHawkularFraction applyDefaults() {
        return this;
    }

    public APMJaxRsTracingBuilder apmJaxRsTracingBuilder() {
        return this.apmJaxRsTracingBuilder;
    }

    public ServerTracingDynamicFeature.Builder getJaxrsTraceBuilder() {
        return this.apmJaxRsTracingBuilder.build();
    }

    public static class TraceRecorderBuilder
    extends BatchTraceRecorder.BatchTraceRecorderBuilder {
        public TraceRecorderBuilder withHttpRecorder(String userName, String password, String url) {
            super.withTracePublisher((TracePublisher)new TracePublisherRESTClient(userName, password, url));
            return this;
        }

        @Deprecated
        public BatchTraceRecorder.BatchTraceRecorderBuilder withTracePublisher(TracePublisher tracePublisher) {
            throw new IllegalArgumentException("Please use #withHttpRecoreder");
        }
    }

    public class APMJaxRsTracingBuilder {
        private int percentageSampling = 100;
        private String serviceName;
        private String buildStamp;
        private boolean consoleRecorder;
        private TraceRecorderBuilder batchTraceRecorderBuilder;

        public APMJaxRsTracingBuilder withSampleRate(int percentage) {
            this.percentageSampling = percentage;
            return this;
        }

        public APMJaxRsTracingBuilder withServiceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public APMJaxRsTracingBuilder withBuilStamp(String buildStamp) {
            this.buildStamp = buildStamp;
            return this;
        }

        public APMJaxRsTracingBuilder withConsoleRecorder(boolean consoleRecorder) {
            this.consoleRecorder = consoleRecorder;
            return this;
        }

        public APMJaxRsTracingBuilder withBatchRecorderBuilder(TraceRecorderBuilder builder) {
            this.batchTraceRecorderBuilder = builder;
            return this;
        }

        private ServerTracingDynamicFeature.Builder build() {
            LoggingRecorder traceRecorder = this.consoleRecorder ? new LoggingRecorder() : (this.batchTraceRecorderBuilder != null ? this.batchTraceRecorderBuilder.build() : new BatchTraceRecorder());
            APMTracer apmTracer = new APMTracer((TraceRecorder)traceRecorder, PercentageSampler.withPercentage((int)this.percentageSampling), new DeploymentMetaData(this.serviceName, this.buildStamp));
            GlobalTracer.register((Tracer)apmTracer);
            return ServerTracingDynamicFeature.Builder.traceAll((Tracer)apmTracer);
        }
    }
}

