/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.opentracing.runtime;

import javax.inject.Inject;
import org.jboss.logging.Logger;
import org.jboss.shrinkwrap.api.Archive;
import org.wildfly.swarm.spi.api.DeploymentProcessor;
import org.wildfly.swarm.spi.runtime.annotations.DeploymentScoped;
import org.wildfly.swarm.undertow.WARArchive;
import org.wildfly.swarm.undertow.descriptors.WebXmlAsset;

@DeploymentScoped
public class OpenTracingInstaller
implements DeploymentProcessor {
    private static final Logger logger = Logger.getLogger(OpenTracingInstaller.class);
    private final Archive<?> archive;

    @Inject
    public OpenTracingInstaller(Archive archive) {
        this.archive = archive;
    }

    public void process() throws Exception {
        logger.info((Object)"Determining whether to install OpenTracing integration or not.");
        if (this.archive.getName().endsWith(".war")) {
            logger.logf(Logger.Level.INFO, "Installing the OpenTracing integration for the deployment %s", (Object)this.archive.getName());
            WARArchive webArchive = (WARArchive)this.archive.as(WARArchive.class);
            WebXmlAsset webXml = webArchive.findWebXmlAsset();
            logger.logf(Logger.Level.INFO, "Adding the listener org.wildfly.swarm.opentracing.deployment.OpenTracingInitializer", new Object[0]);
            webXml.addListener("org.wildfly.swarm.opentracing.deployment.OpenTracingInitializer");
        }
    }
}

