/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.opentracing.runtime;

import io.opentracing.contrib.web.servlet.filter.TracingFilter;
import javax.inject.Inject;
import org.jboss.logging.Logger;
import org.jboss.shrinkwrap.api.Archive;
import org.wildfly.swarm.opentracing.OpenTracingFraction;
import org.wildfly.swarm.spi.api.DeploymentProcessor;
import org.wildfly.swarm.spi.runtime.annotations.DeploymentScoped;
import org.wildfly.swarm.undertow.WARArchive;
import org.wildfly.swarm.undertow.descriptors.WebXmlAsset;

@DeploymentScoped
public class OpenTracingInstaller
implements DeploymentProcessor {
    private static final Logger logger = Logger.getLogger(OpenTracingInstaller.class);
    private final Archive<?> archive;
    @Inject
    private OpenTracingFraction fraction;

    @Inject
    public OpenTracingInstaller(Archive archive) {
        this.archive = archive;
    }

    public void process() throws Exception {
        logger.info((Object)"Determining whether to install OpenTracing integration or not.");
        if (this.archive.getName().endsWith(".war")) {
            logger.logf(Logger.Level.INFO, "Installing the OpenTracing integration for the deployment %s", (Object)this.archive.getName());
            WARArchive webArchive = (WARArchive)this.archive.as(WARArchive.class);
            WebXmlAsset webXml = webArchive.findWebXmlAsset();
            logger.logf(Logger.Level.INFO, "Adding the listener org.wildfly.swarm.opentracing.deployment.OpenTracingInitializer", new Object[0]);
            webXml.addListener("org.wildfly.swarm.opentracing.deployment.OpenTracingInitializer");
            this.setContextParamIfNotNull(webXml, TracingFilter.SKIP_PATTERN, this.fraction.getServletSkipPattern());
        }
    }

    private void setContextParamIfNotNull(WebXmlAsset webXml, String key, String value) {
        if (value == null || value.isEmpty()) {
            return;
        }
        webXml.setContextParam(key, new String[]{value});
    }
}

