/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.database.postgresql.runtime;

import javax.enterprise.inject.Any;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.wildfly.swarm.datasources.DatasourcesFraction;
import org.wildfly.swarm.spi.api.Customizer;
import org.wildfly.swarm.spi.runtime.annotations.Pre;

@Singleton
@Pre
public class PostgreSQLDatasourceCustomizer
implements Customizer {
    @Inject
    @Any
    Instance<DatasourcesFraction> datasourcesFractionInstance;

    public void customize() {
        if (!this.datasourcesFractionInstance.isUnsatisfied()) {
            String dsName = System.getProperty("swarm.ds.name", "ExampleDS");
            String driverName = System.getProperty("swarm.jdbc.driver", "postgresql");
            ((DatasourcesFraction)this.datasourcesFractionInstance.get()).jdbcDriver(driverName, d -> {
                d.driverClassName("org.postgresql.Driver");
                d.xaDatasourceClass("org.postgresql.xa.PGXADataSource");
                d.driverModuleName("org.postgresql");
            }).dataSource(dsName, ds -> {
                ds.driverName(driverName);
                ds.connectionUrl(System.getProperty("swarm.ds.connection.url", "jdbc:postgresql://localhost:5432/test"));
                ds.userName(System.getProperty("swarm.ds.username", "postgres"));
                ds.password(System.getProperty("swarm.ds.password", "postgres"));
            });
        }
    }
}

