/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.remoting;

import org.wildfly.swarm.config.Remoting;
import org.wildfly.swarm.config.Undertow;
import org.wildfly.swarm.config.remoting.EndpointConfiguration;
import org.wildfly.swarm.config.remoting.HTTPConnector;
import org.wildfly.swarm.config.undertow.Server;
import org.wildfly.swarm.config.undertow.server.HTTPListener;
import org.wildfly.swarm.spi.api.Fraction;
import org.wildfly.swarm.spi.api.annotations.Configuration;
import org.wildfly.swarm.spi.api.annotations.Default;

@Configuration(marshal=true, extension="org.jboss.as.remoting", parserFactoryClassName="org.wildfly.swarm.remoting.runtime.RemotingParserFactory")
public class RemotingFraction
extends Remoting<RemotingFraction>
implements Fraction {
    @Default
    public static RemotingFraction defaultFraction() {
        RemotingFraction fraction = new RemotingFraction();
        ((RemotingFraction)fraction.endpointConfiguration(new EndpointConfiguration())).httpConnector(new HTTPConnector("http-remoting-connector").connectorRef("default"));
        return fraction;
    }

    public void postInitialize(Fraction.PostInitContext initContext) {
        HTTPListener listener;
        Server server;
        System.setProperty("swarm.http.eager", "true");
        Undertow undertow = (Undertow)initContext.fraction("undertow");
        if (undertow != null && (server = undertow.subresources().server("default-server")) != null && (listener = server.subresources().httpListener("default")) != null) {
            listener.enabled(Boolean.valueOf(true));
        }
    }
}

