/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.remoting.runtime;

import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jboss.logging.Logger;
import org.wildfly.swarm.remoting.RemotingFraction;
import org.wildfly.swarm.spi.api.Customizer;
import org.wildfly.swarm.spi.api.SocketBinding;
import org.wildfly.swarm.spi.api.SocketBindingGroup;
import org.wildfly.swarm.spi.runtime.annotations.ConfigurationValue;
import org.wildfly.swarm.spi.runtime.annotations.Post;

@Post
@Singleton
public class RemotingLegacyConnectorCustomizer
implements Customizer {
    private static Logger LOG = Logger.getLogger((String)"org.wildfly.swarm.remoting");
    public static final int DEFAULT_LEGACY_REMOTING_PORT = 4777;
    @Inject
    private RemotingFraction remoting;
    @Inject
    @ConfigurationValue(value="swarm.remoting.port")
    private Integer port;
    @Inject
    @Named(value="standard-sockets")
    private SocketBindingGroup group;

    public void customize() {
        if (this.remoting.isRequireLegacyConnector() || this.port != null) {
            LOG.info((Object)"Remoting installed but Undertnow not available. Enabled legacy connector on port 4777.");
            this.remoting.connector("legacy", connector -> connector.socketBinding("legacy-remoting"));
            if (this.port == null) {
                this.port = 4777;
            }
            this.group.socketBinding(new SocketBinding("legacy-remoting").port(this.port.intValue()));
        }
    }
}

