/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.remoting.runtime;

import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jboss.logging.Logger;
import org.wildfly.swarm.remoting.RemotingFraction;
import org.wildfly.swarm.spi.api.Customizer;
import org.wildfly.swarm.spi.api.SocketBinding;
import org.wildfly.swarm.spi.api.SocketBindingGroup;
import org.wildfly.swarm.spi.runtime.annotations.Post;

@Post
@Singleton
public class RemotingLegacyConnectorCustomizer
implements Customizer {
    private static Logger LOG = Logger.getLogger((String)"org.wildfly.swarm.remoting");
    @Inject
    private RemotingFraction remoting;
    @Inject
    @Named(value="standard-sockets")
    private SocketBindingGroup group;

    public void customize() {
        if (this.remoting.isRequireLegacyConnector()) {
            LOG.info((Object)"Remoting installed but Undertow not available. Enabled legacy connector on port 4447.");
            this.remoting.connector("legacy", connector -> connector.socketBinding("legacy-remoting"));
            this.group.socketBinding(new SocketBinding("legacy-remoting").port(this.remoting.port()));
        }
    }
}

