/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.resource.adapters;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import org.wildfly.swarm.config.resource.adapters.ResourceAdapter;
import org.wildfly.swarm.config.resource.adapters.resource_adapter.AdminObjects;
import org.wildfly.swarm.config.resource.adapters.resource_adapter.ConfigProperties;
import org.wildfly.swarm.config.resource.adapters.resource_adapter.ConnectionDefinitions;
import org.wildfly.swarm.container.util.XmlWriter;

enum IronJacamarXmlAssetImpl {
    INSTANCE;


    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String transform(ResourceAdapter<?> ra) {
        StringWriter str = new StringWriter();
        try (XmlWriter out = new XmlWriter((Writer)str);){
            XmlWriter.Element ironJacamarElement = out.element("ironjacamar");
            if (ra.beanvalidationgroups() != null && !ra.beanvalidationgroups().isEmpty()) {
                XmlWriter.Element beanValidationGroupsElement = null;
                for (Object group : ra.beanvalidationgroups()) {
                    beanValidationGroupsElement = this.writeElement(ironJacamarElement, beanValidationGroupsElement, "bean-validation-groups", "bean-validation-group", group.toString());
                }
                beanValidationGroupsElement.end();
            }
            ironJacamarElement = this.writeElement(null, ironJacamarElement, "ironjacamar", "bootstrap-context", ra.bootstrapContext());
            for (ConfigProperties prop : ra.subresources().configProperties()) {
                ironJacamarElement = this.writeConfigProperty(null, ironJacamarElement, "ironjacamar", prop);
            }
            ironJacamarElement = this.writeElement(null, ironJacamarElement, "ironjacamar", "transaction-support", ra.transactionSupport());
            if (ra.subresources().connectionDefinitions() != null && !ra.subresources().connectionDefinitions().isEmpty()) {
                XmlWriter.Element connDefsElement = ironJacamarElement.element("connection-definitions");
                for (ConnectionDefinitions connDef : ra.subresources().connectionDefinitions()) {
                    XmlWriter.Element connDefElement = null;
                    connDefElement = this.writeAttribute(connDefsElement, connDefElement, "connection-definition", "use-ccm", connDef.useCcm());
                    connDefElement = this.writeAttribute(connDefsElement, connDefElement, "connection-definition", "class-name", connDef.className());
                    connDefElement = this.writeAttribute(connDefsElement, connDefElement, "connection-definition", "jndi-name", connDef.jndiName());
                    connDefElement = this.writeAttribute(connDefsElement, connDefElement, "connection-definition", "enabled", connDef.enabled());
                    connDefElement = this.writeAttribute(connDefsElement, connDefElement, "connection-definition", "use-java-context", connDef.useJavaContext());
                    if (connDef.subresources().configProperties() != null && !connDef.subresources().configProperties().isEmpty()) {
                        for (ConfigProperties prop : connDef.subresources().configProperties()) {
                            connDefElement = this.writeConfigProperty(connDefsElement, connDefElement, "connection-definition", prop);
                        }
                    }
                    XmlWriter.Element poolElement = null;
                    poolElement = this.writeElement(connDefElement, poolElement, "pool", "min-pool-size", connDef.minPoolSize());
                    poolElement = this.writeElement(connDefElement, poolElement, "pool", "max-pool-size", connDef.maxPoolSize());
                    poolElement = this.writeElement(connDefElement, poolElement, "pool", "prefill", connDef.poolPrefill());
                    poolElement = this.writeElement(connDefElement, poolElement, "pool", "use-strict-min", connDef.poolUseStrictMin());
                    if ((poolElement = this.writeElement(connDefElement, poolElement, "pool", "flush-strategy", connDef.flushStrategy())) != null) {
                        poolElement.end();
                    }
                    XmlWriter.Element securityElement = null;
                    securityElement = this.writeElement(connDefElement, securityElement, "security", "security-domain", connDef.securityDomain());
                    if ((securityElement = this.writeElement(connDefElement, securityElement, "security", "security-domain-and-application", connDef.securityDomainAndApplication())) != null) {
                        securityElement.end();
                    }
                    XmlWriter.Element timeoutElement = null;
                    timeoutElement = this.writeElement(connDefsElement, timeoutElement, "timeout", "blocking-timeout-millis", connDef.blockingTimeoutWaitMillis());
                    timeoutElement = this.writeElement(connDefsElement, timeoutElement, "timeout", "idle-timeout-minutes", connDef.idleTimeoutMinutes());
                    timeoutElement = this.writeElement(connDefsElement, timeoutElement, "timeout", "allocation-retry", connDef.allocationRetry());
                    timeoutElement = this.writeElement(connDefsElement, timeoutElement, "timeout", "allocation-retry-wait-millis", connDef.allocationRetryWaitMillis());
                    if ((timeoutElement = this.writeElement(connDefsElement, timeoutElement, "timeout", "xa-resource-timeout", connDef.xaResourceTimeout())) != null) {
                        timeoutElement.end();
                    }
                    XmlWriter.Element validationElement = null;
                    validationElement = this.writeElement(connDefsElement, validationElement, "validation", "background-validation", connDef.backgroundValidation());
                    validationElement = this.writeElement(connDefsElement, validationElement, "validation", "background-validation-millis", connDef.backgroundValidationMillis());
                    if ((validationElement = this.writeElement(connDefsElement, validationElement, "validation", "use-fast-fail", connDef.useFastFail())) != null) {
                        validationElement.end();
                    }
                    XmlWriter.Element recoveryElement = null;
                    XmlWriter.Element recoverCredentialElement = null;
                    XmlWriter.Element recoveryPluginElement = null;
                    if (connDef.recoveryUsername() != null || connDef.recoveryPassword() != null || connDef.recoverySecurityDomain() != null) {
                        recoveryElement = connDefsElement.element("recovery");
                        recoveryElement = this.writeAttribute(connDefsElement, recoveryElement, "recovery", "no-recovery", connDef.noRecovery());
                        recoverCredentialElement = this.writeElement(recoveryElement, recoverCredentialElement, "recover-credential", "user-name", connDef.recoveryUsername());
                        recoverCredentialElement = this.writeElement(recoveryElement, recoverCredentialElement, "recover-credential", "password", connDef.recoveryPassword());
                        if ((recoverCredentialElement = this.writeElement(recoveryElement, recoverCredentialElement, "recover-credential", "security-domain", connDef.recoverySecurityDomain())) != null) {
                            recoverCredentialElement.end();
                        }
                    }
                    if (connDef.recoveryPluginClassName() != null || connDef.recoveryPluginProperties() != null && !connDef.recoveryPluginProperties().isEmpty()) {
                        if (recoveryElement == null) {
                            recoveryElement = connDefsElement.element("recovery");
                            recoveryElement = this.writeAttribute(connDefsElement, recoveryElement, "recovery", "no-recovery", connDef.noRecovery());
                        }
                        recoveryPluginElement = this.writeAttribute(recoveryElement, recoveryPluginElement, "recover-plugin", "class-name", connDef.recoveryPluginClassName());
                        recoveryPluginElement = this.writeElement(recoveryElement, recoveryPluginElement, "recover-plugin", "user-name", connDef.recoveryUsername());
                        for (Object key : connDef.recoveryPluginProperties().keySet()) {
                            recoveryPluginElement.element("config-property").attr("name", key.toString()).content(connDef.recoveryPluginProperties().get(key).toString()).end();
                        }
                        if (recoveryPluginElement != null) {
                            recoveryPluginElement.end();
                        }
                    }
                    if (recoveryElement != null) {
                        recoveryElement.end();
                    }
                    connDefElement.end();
                }
                connDefsElement.end();
            }
            if (ra.subresources().adminObjects() != null && !ra.subresources().adminObjects().isEmpty()) {
                XmlWriter.Element adminObjsElement = ironJacamarElement.element("admin-objects");
                for (AdminObjects adminObject : ra.subresources().adminObjects()) {
                    XmlWriter.Element adminObjElement = null;
                    adminObjElement = this.writeAttribute(adminObjsElement, adminObjElement, "admin-object", "class-name", adminObject.className());
                    adminObjElement = this.writeAttribute(adminObjsElement, adminObjElement, "admin-object", "jndi-name", adminObject.jndiName());
                    adminObjElement = this.writeAttribute(adminObjsElement, adminObjElement, "admin-object", "enabled", adminObject.enabled());
                    adminObjElement = this.writeAttribute(adminObjsElement, adminObjElement, "admin-object", "use-java-context", adminObject.useJavaContext());
                    for (ConfigProperties prop : adminObject.subresources().configProperties()) {
                        adminObjElement = this.writeConfigProperty(adminObjsElement, adminObjElement, "admin-object", prop);
                    }
                    if (adminObjElement == null) continue;
                    adminObjElement.end();
                }
                adminObjsElement.end();
            }
            ironJacamarElement.end();
            out.close();
            String string = str.toString();
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private XmlWriter.Element writeElement(XmlWriter.Element parentParentElement, XmlWriter.Element parentElement, String parentElementName, String name, Object value) throws IOException {
        XmlWriter.Element localParentElement = parentElement;
        if (value != null) {
            if (localParentElement == null) {
                localParentElement = parentParentElement.element(parentElementName);
            }
            localParentElement.element(name).content(value.toString()).end();
        }
        return localParentElement;
    }

    private XmlWriter.Element writeAttribute(XmlWriter.Element parentParentElement, XmlWriter.Element parentElement, String parentElementName, String name, Object value) throws IOException {
        XmlWriter.Element localParentElement = parentElement;
        if (value != null) {
            if (localParentElement == null) {
                localParentElement = parentParentElement.element(parentElementName);
            }
            localParentElement.attr(name, value.toString());
        }
        return localParentElement;
    }

    private XmlWriter.Element writeConfigProperty(XmlWriter.Element parentParentElement, XmlWriter.Element parentElement, String parentElementName, ConfigProperties<?> prop) throws IOException {
        XmlWriter.Element localParentElement = parentElement;
        if (prop != null) {
            if (localParentElement == null) {
                localParentElement = parentParentElement.element(parentElementName);
            }
            localParentElement.element("config-property").attr("name", prop.getKey()).content(prop.value()).end();
        }
        return localParentElement;
    }
}

