/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.resource.adapters.internal;

import java.io.File;
import java.util.logging.Logger;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ArchivePath;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.FileAsset;
import org.jboss.shrinkwrap.impl.base.container.ResourceAdapterContainerBase;
import org.jboss.shrinkwrap.impl.base.path.BasicPath;
import org.wildfly.swarm.config.resource.adapters.ResourceAdapter;
import org.wildfly.swarm.config.resource.adapters.ResourceAdapterConsumer;
import org.wildfly.swarm.resource.adapters.IronJacamarXmlAsset;
import org.wildfly.swarm.resource.adapters.RARArchive;

public class RARArchiveImpl
extends ResourceAdapterContainerBase<RARArchive>
implements RARArchive {
    private static final Logger log = Logger.getLogger(RARArchiveImpl.class.getName());
    private static final ArchivePath PATH_MANIFEST = new BasicPath("META-INF");
    private static final ArchivePath PATH_RESOURCE = new BasicPath("/");
    private static final ArchivePath PATH_LIBRARY = new BasicPath("/");

    public RARArchiveImpl(Archive<?> delegate) {
        super(RARArchive.class, delegate);
    }

    @Override
    public RARArchiveImpl resourceAdapter(String key, ResourceAdapterConsumer consumer) {
        ResourceAdapter ra = new ResourceAdapter(key);
        consumer.accept(ra);
        this.resourceAdapter(ra);
        return this;
    }

    @Override
    public RARArchive resourceAdapter(ResourceAdapter ra) {
        this.getArchive().add((Asset)new IronJacamarXmlAsset(ra), "META-INF/ironjacamar.xml");
        return this;
    }

    @Override
    public RARArchive resourceAdapter(File ironjacamarFile) {
        this.getArchive().add((Asset)new FileAsset(ironjacamarFile), "META-INF/ironjacamar.xml");
        return this;
    }

    @Override
    public RARArchive resourceAdapter(Asset ironjacamarAsset) {
        this.getArchive().add(ironjacamarAsset, "META-INF/ironjacamar.xml");
        return this;
    }

    public ArchivePath getLibraryPath() {
        return PATH_LIBRARY;
    }

    protected ArchivePath getResourcePath() {
        return PATH_RESOURCE;
    }

    protected ArchivePath getManifestPath() {
        return PATH_MANIFEST;
    }

    protected ArchivePath getClassesPath() {
        throw new UnsupportedOperationException("ResourceAdapterArchive does not support classes");
    }
}

