/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.netflix.ribbon.runtime;

import com.netflix.loadbalancer.Server;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jboss.as.network.SocketBinding;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.clustering.dispatcher.Command;
import org.wildfly.clustering.dispatcher.CommandDispatcher;
import org.wildfly.clustering.dispatcher.CommandDispatcherFactory;
import org.wildfly.clustering.group.Group;
import org.wildfly.clustering.group.Node;
import org.wildfly.swarm.netflix.ribbon.runtime.AdvertiseCommand;
import org.wildfly.swarm.netflix.ribbon.runtime.ClusterRegistry;
import org.wildfly.swarm.netflix.ribbon.runtime.RequestAdvertisementsCommand;
import org.wildfly.swarm.netflix.ribbon.runtime.UnadvertiseCommand;

public class ClusterManager
implements Service<ClusterManager>,
Group.Listener {
    public static final ServiceName SERVICE_NAME = ServiceName.of((String[])new String[]{"netflix", "ribbon", "cluster", "manager"});
    private InjectedValue<CommandDispatcherFactory> commandDispatcherFactoryInjector = new InjectedValue();
    private InjectedValue<SocketBinding> socketBindingInjector = new InjectedValue();
    private CommandDispatcher<ClusterManager> dispatcher;
    private Set<String> advertisements = new HashSet<String>();
    private Node node;

    public Injector<CommandDispatcherFactory> getCommandDispatcherFactoryInjector() {
        return this.commandDispatcherFactoryInjector;
    }

    public Injector<SocketBinding> getSocketBindingInjector() {
        return this.socketBindingInjector;
    }

    public void start(StartContext startContext) throws StartException {
        ((CommandDispatcherFactory)this.commandDispatcherFactoryInjector.getValue()).getGroup().addListener((Group.Listener)this);
        this.dispatcher = ((CommandDispatcherFactory)this.commandDispatcherFactoryInjector.getValue()).createCommandDispatcher((Object)"netflix.ribbon.manager", (Object)this);
        this.node = ((CommandDispatcherFactory)this.commandDispatcherFactoryInjector.getValue()).getGroup().getLocalNode();
        this.requestAdvertisements();
    }

    public void stop(StopContext stopContext) {
        this.dispatcher.close();
    }

    public ClusterManager getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    public void membershipChanged(List<Node> previousMembers, List<Node> members, boolean merged) {
        this.advertiseAll();
        ArrayList<Node> removed = new ArrayList<Node>();
        removed.addAll(previousMembers);
        removed.removeAll(members);
        removed.forEach(e -> ClusterRegistry.INSTANCE.unregisterAll(this.nodeKey((Node)e)));
    }

    protected void requestAdvertisements() {
        try {
            this.dispatcher.submitOnCluster((Command)new RequestAdvertisementsCommand(), new Node[]{this.node});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected synchronized void advertiseAll() {
        for (String each : this.advertisements) {
            this.doAdvertise(each);
        }
    }

    protected synchronized void advertise(String appName) {
        this.advertisements.add(appName);
        this.doAdvertise(appName);
    }

    protected void doAdvertise(String appName) {
        SocketBinding binding = (SocketBinding)this.socketBindingInjector.getValue();
        try {
            this.dispatcher.submitOnCluster((Command)new AdvertiseCommand(this.nodeKey(this.node), appName, binding.getAddress().getHostAddress(), binding.getAbsolutePort()), new Node[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected synchronized void unadvertise(String appName) {
        this.advertisements.remove(appName);
        try {
            this.dispatcher.submitOnCluster((Command)new UnadvertiseCommand(this.nodeKey(this.node), appName), new Node[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void register(String nodeKey, String appName, Server server) {
        ClusterRegistry.INSTANCE.register(nodeKey, appName, server);
    }

    void unregister(String nodeKey, String appName) {
        ClusterRegistry.INSTANCE.unregister(nodeKey, appName);
    }

    String nodeKey(Node node) {
        return node.getName() + ":" + node.getSocketAddress().toString();
    }
}

