/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.netflix.ribbon.secured.client;

import com.netflix.client.RetryHandler;
import com.netflix.client.config.ClientConfigFactory;
import com.netflix.client.config.IClientConfig;
import com.netflix.loadbalancer.reactive.ExecutionListener;
import com.netflix.ribbon.RibbonTransportFactory;
import com.netflix.ribbon.transport.netty.RibbonTransport;
import com.netflix.ribbon.transport.netty.http.LoadBalancingHttpClient;
import com.netflix.ribbon.transport.netty.http.NettyHttpLoadBalancerErrorHandler;
import io.netty.buffer.ByteBuf;
import io.reactivex.netty.pipeline.PipelineConfigurator;
import io.reactivex.netty.pipeline.PipelineConfiguratorComposite;
import io.reactivex.netty.protocol.http.HttpObjectAggregationConfigurator;
import io.reactivex.netty.protocol.http.client.HttpClient;
import io.reactivex.netty.protocol.http.client.HttpClientPipelineConfigurator;
import io.reactivex.netty.protocol.http.client.HttpClientRequest;
import io.reactivex.netty.protocol.http.client.HttpClientResponse;
import java.util.ArrayList;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.wildfly.swarm.netflix.ribbon.secured.client.BearerHeaderAdder;

public class SecuredTransportFactory
extends RibbonTransportFactory {
    public static final ScheduledExecutorService poolCleanerScheduler = Executors.newScheduledThreadPool(1);
    private final int maxChunkSize;

    protected SecuredTransportFactory(int maxChunkSize) {
        super(ClientConfigFactory.DEFAULT);
        this.maxChunkSize = maxChunkSize;
    }

    private static RetryHandler getDefaultHttpRetryHandlerWithConfig(IClientConfig config) {
        return new NettyHttpLoadBalancerErrorHandler(config);
    }

    public HttpClient<ByteBuf, ByteBuf> newHttpClient(IClientConfig config) {
        ArrayList<ExecutionListener<HttpClientRequest<ByteBuf>, HttpClientResponse<ByteBuf>>> listeners = new ArrayList<ExecutionListener<HttpClientRequest<ByteBuf>, HttpClientResponse<ByteBuf>>>();
        listeners.add(this.createBearerHeaderAdder());
        PipelineConfiguratorComposite pipelineConfigurator = new PipelineConfiguratorComposite(new PipelineConfigurator[]{new HttpClientPipelineConfigurator(), new HttpObjectAggregationConfigurator(this.maxChunkSize)});
        LoadBalancingHttpClient client = LoadBalancingHttpClient.builder().withClientConfig(config).withExecutorListeners(listeners).withRetryHandler(SecuredTransportFactory.getDefaultHttpRetryHandlerWithConfig(config)).withPipelineConfigurator((PipelineConfigurator)pipelineConfigurator).withPoolCleanerScheduler(RibbonTransport.poolCleanerScheduler).build();
        return client;
    }

    private ExecutionListener<HttpClientRequest<ByteBuf>, HttpClientResponse<ByteBuf>> createBearerHeaderAdder() {
        return new BearerHeaderAdder();
    }
}

