/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.netflix.ribbon.secured.client;

import com.netflix.loadbalancer.reactive.ExecutionContext;
import com.netflix.loadbalancer.reactive.ExecutionInfo;
import com.netflix.loadbalancer.reactive.ExecutionListener;
import io.netty.buffer.ByteBuf;
import io.reactivex.netty.protocol.http.client.HttpClientRequest;
import io.reactivex.netty.protocol.http.client.HttpClientResponse;
import org.keycloak.KeycloakSecurityContext;
import org.wildfly.swarm.keycloak.deployment.KeycloakSecurityContextAssociation;

public class BearerHeaderAdder
implements ExecutionListener<HttpClientRequest<ByteBuf>, HttpClientResponse<ByteBuf>> {
    public void onExecutionStart(ExecutionContext<HttpClientRequest<ByteBuf>> context) throws ExecutionListener.AbortExecutionException {
    }

    public void onStartWithServer(ExecutionContext<HttpClientRequest<ByteBuf>> context, ExecutionInfo info) throws ExecutionListener.AbortExecutionException {
        KeycloakSecurityContext securityContext = KeycloakSecurityContextAssociation.get();
        if (securityContext != null) {
            HttpClientRequest request = (HttpClientRequest)context.getRequest();
            request.withHeader("Authorization", "Bearer " + securityContext.getTokenString());
            context.put(KeycloakSecurityContextAssociation.class.getName(), (Object)securityContext);
        } else {
            KeycloakSecurityContextAssociation.disassociate();
        }
    }

    public void onExceptionWithServer(ExecutionContext<HttpClientRequest<ByteBuf>> context, Throwable exception, ExecutionInfo info) {
        KeycloakSecurityContext securityContext = (KeycloakSecurityContext)context.get(KeycloakSecurityContextAssociation.class.getName());
        if (securityContext != null) {
            KeycloakSecurityContextAssociation.associate((KeycloakSecurityContext)securityContext);
        } else {
            KeycloakSecurityContextAssociation.disassociate();
        }
    }

    public void onExecutionSuccess(ExecutionContext<HttpClientRequest<ByteBuf>> context, HttpClientResponse<ByteBuf> response, ExecutionInfo info) {
        KeycloakSecurityContext securityContext = (KeycloakSecurityContext)context.get(KeycloakSecurityContextAssociation.class.getName());
        if (securityContext != null) {
            KeycloakSecurityContextAssociation.associate((KeycloakSecurityContext)securityContext);
        } else {
            KeycloakSecurityContextAssociation.disassociate();
        }
    }

    public void onExecutionFailed(ExecutionContext<HttpClientRequest<ByteBuf>> context, Throwable finalException, ExecutionInfo info) {
        KeycloakSecurityContext securityContext = (KeycloakSecurityContext)context.get(KeycloakSecurityContextAssociation.class.getName());
        if (securityContext != null) {
            KeycloakSecurityContextAssociation.associate((KeycloakSecurityContext)securityContext);
        } else {
            KeycloakSecurityContextAssociation.disassociate();
        }
    }
}

