/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.ribbon.webapp.runtime;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.servlet.AsyncContext;
import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.wildfly.swarm.netflix.ribbon.RibbonExternalAddressMapper;
import org.wildfly.swarm.netflix.ribbon.RibbonServer;
import org.wildfly.swarm.netflix.ribbon.RibbonTopology;
import org.wildfly.swarm.netflix.ribbon.RibbonTopologyListener;

@WebServlet(urlPatterns={"/system/stream"}, asyncSupported=true)
public class RibbonToTheCurbSSEServlet
extends HttpServlet {
    private RibbonTopology topology;
    private RibbonExternalAddressMapper externalAddressMapper;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        try {
            InitialContext context = new InitialContext();
            this.topology = (RibbonTopology)context.lookup("jboss/ribbon/cluster");
        }
        catch (NamingException e) {
            e.printStackTrace();
            throw new ServletException();
        }
        try {
            Class<?> clazz = Class.forName(config.getServletContext().getInitParameter("externalAddressMapper"));
            this.externalAddressMapper = (RibbonExternalAddressMapper)clazz.newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ServletException((Throwable)e);
        }
    }

    protected void doGet(final HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        resp.setContentType("text/event-stream");
        resp.setCharacterEncoding("UTF-8");
        AsyncContext asyncContext = req.startAsync();
        final PrintWriter writer = resp.getWriter();
        final Object writeLock = new Object();
        final RibbonTopologyListener topologyListener = new RibbonTopologyListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onChange(RibbonTopology topology) {
                String json = RibbonToTheCurbSSEServlet.this.topologyToJson(req.getServerPort());
                Object object = writeLock;
                synchronized (object) {
                    writer.write("event: topologyChange\n");
                    writer.write("data: " + json);
                    writer.flush();
                }
            }
        };
        final Thread keepAlive = new Thread(() -> {
            try {
                while (true) {
                    Thread.sleep(15000L);
                    Object object = writeLock;
                    synchronized (object) {
                        writer.write(":\n\n");
                        writer.flush();
                    }
                }
            }
            catch (InterruptedException e) {
                return;
            }
        });
        asyncContext.setTimeout(0L);
        asyncContext.addListener(new AsyncListener(){

            public void onComplete(AsyncEvent asyncEvent) throws IOException {
                RibbonToTheCurbSSEServlet.this.topology.removeListener(topologyListener);
                keepAlive.interrupt();
            }

            public void onTimeout(AsyncEvent asyncEvent) throws IOException {
                RibbonToTheCurbSSEServlet.this.topology.removeListener(topologyListener);
                keepAlive.interrupt();
            }

            public void onError(AsyncEvent asyncEvent) throws IOException {
                RibbonToTheCurbSSEServlet.this.topology.removeListener(topologyListener);
                keepAlive.interrupt();
            }

            public void onStartAsync(AsyncEvent asyncEvent) throws IOException {
            }
        });
        this.topology.addListener(topologyListener);
        String json = this.topologyToJson(req.getServerPort());
        writer.write("event: topologyChange\n");
        writer.write("data: " + json);
        writer.flush();
        keepAlive.start();
    }

    protected String topologyToJson(int externalPort) {
        StringBuilder json = new StringBuilder();
        json.append("{");
        Map map = this.topology.asMap();
        Set keys = map.keySet();
        Iterator keyIter = keys.iterator();
        while (keyIter.hasNext()) {
            String key = (String)keyIter.next();
            json.append("  ").append('\"').append(key).append('\"').append(": [");
            List list = (List)map.get(key);
            Iterator listIter = list.iterator();
            while (listIter.hasNext()) {
                RibbonServer server = (RibbonServer)listIter.next();
                server = this.externalAddressMapper.toExternal(server, externalPort);
                json.append("    ").append('\"').append(server).append('\"');
                if (listIter.hasNext()) {
                    json.append(", ");
                }
                json.append("");
            }
            json.append("  ]");
            if (keyIter.hasNext()) {
                json.append(",");
            }
            json.append("");
        }
        json.append("}\n\n");
        return json.toString();
    }
}

