/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.ribbon.webapp.runtime;

import java.util.ArrayList;
import java.util.List;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.ClassLoaderAsset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.wildfly.swarm.container.runtime.AbstractServerConfiguration;
import org.wildfly.swarm.netflix.ribbon.RibbonArchive;
import org.wildfly.swarm.ribbon.webapp.RibbonWebAppFraction;
import org.wildfly.swarm.ribbon.webapp.runtime.RibbonToTheCurbSSEServlet;
import org.wildfly.swarm.undertow.WARArchive;

public class RibbonWebAppConfiguration
extends AbstractServerConfiguration<RibbonWebAppFraction> {
    private static final String DEFAULT_CONTEXT = "/ribbon";

    public RibbonWebAppConfiguration() {
        super(RibbonWebAppFraction.class);
    }

    public RibbonWebAppFraction defaultFraction() {
        return new RibbonWebAppFraction();
    }

    public List<Archive> getImplicitDeployments(RibbonWebAppFraction fraction) throws Exception {
        String context = System.getProperty("swarm.ribbon.context.path");
        if (context == null) {
            context = DEFAULT_CONTEXT;
        }
        ArrayList<Archive> list = new ArrayList<Archive>();
        WARArchive war = (WARArchive)ShrinkWrap.create(WARArchive.class, (String)"ribbon-webapp.war");
        war.addAsWebInfResource((Asset)new StringAsset(this.getWebXml(fraction)), "web.xml");
        war.addClass(RibbonToTheCurbSSEServlet.class);
        war.addClass(fraction.externalAddressMapper());
        war.addModule("org.wildfly.swarm.netflix.ribbon");
        war.addAsWebResource((Asset)new ClassLoaderAsset("ribbon.js", ((Object)((Object)this)).getClass().getClassLoader()), "ribbon.js");
        war.setContextRoot(context);
        war.as(RibbonArchive.class);
        list.add((Archive)war);
        return list;
    }

    protected String getWebXml(RibbonWebAppFraction fraction) {
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?><web-app xmlns=\"http://java.sun.com/xml/ns/javaee\"    xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"    xsi:schemaLocation=\"http://java.sun.com/xml/ns/javaee                        http://java.sun.com/xml/ns/javaee/web-app_3_0.xsd\"    version=\"3.0\">    <context-param>        <param-name>externalAddressMapper</param-name>        <param-value>" + fraction.externalAddressMapper().getName() + "</param-value>" + "    </context-param>" + "</web-app>";
    }
}

